package cn.quantgroup.big.stms.common.aviator.ext.function;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorDecimal;
import com.googlecode.aviator.runtime.type.AviatorObject;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;

public class RoundUpFunction extends AbstractFunction {

	@Override
	public AviatorObject call(Map<String, Object> env, AviatorObject number) {
		Number num = FunctionUtils.getNumberValue(number, env);

		if (num == null) {
			return AviatorDecimal.valueOf("0.00");
		}

		BigDecimal m = BigDecimal.valueOf(num.doubleValue()).setScale(2, RoundingMode.UP);

		return AviatorDecimal.valueOf(m);

	}

	@Override
	public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
		Number num = FunctionUtils.getNumberValue(arg1, env);

		if (num == null) {
			return AviatorDecimal.valueOf("0.00");
		}

		Number scale = FunctionUtils.getNumberValue(arg2, env);
		int newScale = scale == null ? 2 : scale.intValue();

		BigDecimal m = BigDecimal.valueOf(num.doubleValue()).setScale(newScale, RoundingMode.UP);

		return AviatorDecimal.valueOf(m);
	}

	@Override
	public String getName() {
		return "math.round_up";
	}

}
