package cn.quantgroup.big.stms.common.aviator.ext.function;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorDecimal;
import com.googlecode.aviator.runtime.type.AviatorObject;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

/**
 * 四舍五入
 * @author  rong yang
 *
 */
public class RoundFunction extends AbstractFunction {

	@Override
	public AviatorObject call(Map<String, Object> env, AviatorObject number) {
		Number num = FunctionUtils.getNumberValue(number, env);

		if (num == null) {
			return AviatorDecimal.valueOf("0.00");
		}

		BigDecimal m = BigDecimal.valueOf(num.doubleValue()).setScale(2, RoundingMode.HALF_UP);

		return AviatorDecimal.valueOf(m);

	}

	@Override
	public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
		Number num = FunctionUtils.getNumberValue(arg1, env);

		if (num == null) {
			return AviatorDecimal.valueOf("0.00");
		}

		Number scale = FunctionUtils.getNumberValue(arg2, env);
		int newScale = scale == null ? 2 : scale.intValue();

		BigDecimal m = new BigDecimal(num.toString()).setScale(newScale, RoundingMode.HALF_UP);

		return AviatorDecimal.valueOf(m);
	}

	@Override
	public String getName() {
		return "math.round";
	}

	public static void main(String[] args) {
		AviatorEvaluator.setOption(Options.ALWAYS_PARSE_FLOATING_POINT_NUMBER_INTO_DECIMAL, true);
		AviatorEvaluator.addFunction(new RoundFunction());
		AviatorEvaluator.addFunction(new CaseFunction());
		Map<String,Object> env = new HashMap<>();
		env.put("term",6);
		Object rs = AviatorEvaluator.execute("case(term <= 6, 6000.00*(0.04670-0.472*math.round((3542.67/78000),5))-130.7923, term == 9, 6000.00*(0.07502-0.508*math.round((3542.67/78000),5))-130.7923, term == 12, 6000.00*(0.10328-0.544*math.round((3542.67/78000),5))-130.7923)");
		System.out.println(rs);

		rs = AviatorEvaluator.execute("math.round(3.424445,5)");
		System.out.println(rs);
		rs = AviatorEvaluator.execute("math.round(3.426444,5)");
		System.out.println(rs);



	}
}
