package cn.quantgroup.big.stms.common.aviator.ext.function;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.function.AbstractVariadicFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorObject;

import java.util.HashMap;
import java.util.Map;

/**
 * decode 函数 与oracle的decode函数定义一样
 * 
 * @author rong yang
 *
 */
public class DecodeFunction extends AbstractVariadicFunction {

	/**
	 * 表达式在参数中的步长
	 */
	private final int EXP_STEP = 2;

	@Override
	public String getName() {
		return "decode";

	}
	
	@Override
	public AviatorObject variadicCall(Map<String, Object> env, AviatorObject... args) {
		Number rs = FunctionUtils.getNumberValue(args[0], env);
		for (int i = 1; i < args.length - 1; i += EXP_STEP) {
			if (rs.intValue() == FunctionUtils.getNumberValue(args[i], env).intValue()) {
				return args[i + 1];
			}
		}

		if (args.length % EXP_STEP == 0) {
			return args[args.length - 1];
		} else {
			throw new ExpressionRuntimeException("decode函数没有匹配到合适的值，并且没有默认值！");
		}
	}



	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static void main(String[] args) {
		AviatorEvaluator.addFunction(new DecodeFunction());
		Integer[] a = new Integer[]{20,21,22,23};
		Map map = new HashMap();
		map.put("a", a);
		Object rs = AviatorEvaluator.execute("decode(20,a[0],2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19)",map);
		System.out.println(rs);
	}

	
	

}
