package cn.quantgroup.big.stms.common.aviator.ext.function;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.function.AbstractVariadicFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;

import java.util.Map;

/**
 * case 函数<br/>
 * 表达式判断函数,case(x1,x2,...,xn):表示如果x1为真,则返回x2;x3为真,返回x4.以此类推如果，如果参数有奇数个，最后一个为默认值
 * 
 * 
 * @author rong yang
 *
 */
public class CaseFunction extends AbstractVariadicFunction {

	/**
	 * 表达式在参数中的步长
	 */
	private final int EXP_STEP = 2;

	@Override
	public String getName() {
		return "case";

	}

	@Override
	public AviatorObject variadicCall(Map<String, Object> env, AviatorObject... args) {
		for (int i = 0; i < args.length - 1; i += EXP_STEP) {
			Boolean value = (Boolean)args[i].getValue(env);
			 if(value != null && value.booleanValue()){
				 return args[i + 1];
			 }
		}

		if (args.length % EXP_STEP == 1) {
			return args[args.length - 1];
		} else {
			throw new ExpressionRuntimeException("case函数没有匹配到合适的值，并且没有默认值！");
		}
	}

}
