package cn.quantgroup.big.stms.common.service.impl;

import cn.quantgroup.big.stms.common.model.BaseEntityVO;
import cn.quantgroup.big.stms.common.service.EntityService;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

import java.io.Serializable;
import java.util.List;

public abstract class BaseEntityServiceImpl<T extends BaseEntityVO<ID>, ID extends Serializable>
		implements EntityService<T, ID> {

	@Override
	public <S extends T> S save(S entity) {
		beforeSave(entity);
		entity = getRepository().save(entity);
		afterSave(entity);
		flush();
		return entity;
	}

	@Override
	public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
		if (null == entities) {
			return null;
		}

		entities.forEach(entity -> {
			beforeSave(entity);
			entity = getRepository().save(entity);
			afterSave(entity);
		});

		flush();

		return entities;
	}

	@Override
	public T findById(ID id) {
		return getRepository().findOne(id);
	}

	@Override
	public boolean existsById(ID id) {
		return getRepository().exists(id);
	}

	@Override
	public Iterable<T> findAll() {
		return getRepository().findAll();
	}

	@Override
	public Iterable<T> findAllById(Iterable<ID> ids) {
		return getRepository().findAll(ids);
	}

	@Override
	public long count() {
		return getRepository().count();
	}

	@Override
	public void deleteById(ID id) {
		T obj = findById(id);
		if (null != obj) {
			delete(obj);
		}
	}

	@Override
	public void delete(T entity) {
		beforeDelete(entity);
		getRepository().delete(entity);
		afterDelete(entity);
		flush();
	}

	@Override
	public void deleteAll(Iterable<? extends T> entities) {
		if (null == entities) {
			return;
		}
		entities.forEach(entity -> {
			beforeDelete(entity);
			getRepository().delete(entity);
			afterDelete(entity);
		});
		flush();
	}

	@Override
	public List<T> findAll(Sort sort) {
		return getRepository().findAll(sort);
	}

	@Override
	public void flush() {
		getRepository().flush();
	}

	@Override
	public <S extends T> S saveAndFlush(S entity) {
		beforeSave(entity);
		entity = getRepository().saveAndFlush(entity);
		afterSave(entity);
		return entity;
	}

	// 不建议在业务功能在使用
	@Override
	public void deleteInBatch(Iterable<T> entities) {
		getRepository().deleteInBatch(entities);
	}

	// 不建议在业务功能在使用
	@Override
	public void deleteAllInBatch() {
		getRepository().deleteAllInBatch();
	}

	// 不建议在业务功能在使用
	@Override
	public void deleteAll() {
		getRepository().deleteAll();
	}

	@Override
	public T getOne(ID id) {
		return getRepository().getOne(id);
	}

	@Override
	public <S extends T> List<S> findAll(Example<S> example) {
		return getRepository().findAll(example);
	}

	@Override
	public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
		return getRepository().findAll(example, sort);
	}

	public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable){
		return getRepository().findAll(example,pageable);
	}
	@Override
	public Page<T> findAll(Pageable pageable) {
		return getRepository().findAll(pageable);
	}

	@Override
	public T findOne(Specification<T> spec) {
		return getRepository().findOne(spec);
	}

	@Override
	public List<T> findAll(Specification<T> spec) {
		return getRepository().findAll(spec);
	}

	@Override
	public Page<T> findAll(Specification<T> spec, Pageable pageable) {
		return getRepository().findAll(spec, pageable);
	}

	@Override
	public List<T> findAll(Specification<T> spec, Sort sort) {
		return getRepository().findAll(spec, sort);
	}

	@Override
	public long count(Specification<T> spec) {
		return getRepository().count(spec);
	}

	protected void beforeSave(T entity) {

	}

	protected void afterSave(T entity) {

	}

	protected void beforeDelete(T entity) {

	}

	protected void afterDelete(T entity) {

	}
}
