package cn.quantgroup.big.stms.common.model;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;

@MappedSuperclass
public abstract class BaseTreeVO<T extends BaseTreeVO<T,ID>, ID extends Serializable> extends BaseBasicDataVO<ID> {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/** 树的层级编码 */
	@Column(name = "level_code", length = 255)
	private String levelCode;
	
	/** 全称 **/
	@Column(name = "full_name", length = 255)
	private String fullName;

	/** 树的度 */
	@Column(name = "degree")
	private Integer degree;
	
	/** 是否叶子节点 */
	@Column(name = "is_leaf")
	private Boolean isLeaf;

	public String getLevelCode() {
		return levelCode;
	}

	public void setLevelCode(String levelCode) {
		this.levelCode = levelCode;
	}

	public Integer getDegree() {
		return degree;
	}

	public void setDegree(Integer degree) {
		this.degree = degree;
	}

	
	public Boolean getIsLeaf() {
		return isLeaf;
	}

	public void setIsLeaf(Boolean isLeaf) {
		this.isLeaf = isLeaf;
	}

	public String getFullName() {
		return fullName;
	}

	public void setFullName(String fullName) {
		this.fullName = fullName;
	}

	/**
	 * 获取父节点
	 * @return
	 */
	public abstract T getParent();
	
	/**
	 * 设置父节点
	 * @return
	 */
	public abstract void setParent(T parent);

}
