package cn.quantgroup.big.stms.common.model;

import cn.quantgroup.big.stms.common.enums.BasicDataStatus;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;

@MappedSuperclass
public abstract class BaseBasicDataVO<ID extends Serializable> extends BaseVO<ID> {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    /** 编码 */
    @Column(name = "code", nullable = false, length = 32)
    private String code;

    /** 名称 */
    @Column(name = "name", nullable = false, length = 64)
    private String name;

    /**
     * 状态
     * 
     */
    @Type(type= "cn.quantgroup.big.stms.common.hibernate.usertype.UserEnumType",
        parameters={@Parameter(name="enumClass",value="cn.quantgroup.big.stms.common.enums.BasicDataStatus")})
    @Column(name = "status", columnDefinition = "int")
    private BasicDataStatus status;

    /** 排序号 */
    @Column(name = "sort_no")
    private Integer sortNo;

    /** 描述 */
    @Column(name = "description", length = 128)
    private String description;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description == null ? null : description.trim();
    }

    public BasicDataStatus getStatus() {
        return status;
    }

    public void setStatus(BasicDataStatus status) {
        this.status = status;
    }
}
