package cn.quantgroup.big.stms.common.enums;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * <B>描述：基础数据的状态</B><BR>
 *
 * @author rong yang
 * @version 1.0 2013-06-22
 */
public enum BasicDataStatus implements BaseEnum<Integer> {
    SAVE("新增", 1),
    VALID("有效", 2),
    INVALID("无效", 3);

    private final String name;
    private final Integer value;

    BasicDataStatus(String name, int value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    //@JsonValue//返回前端只返回value，不返回name
    public Integer getValue() {
        return value;
    }

    /**
     * 解决json枚举类型转换问题
     *
     * @param value
     * @return
     */
    @JsonCreator
    public static BasicDataStatus get(int value) {
        for (BasicDataStatus e : values()) {
            if (e.getValue().equals(value)) {
                return e;
            }
        }
        return null;
    }

}
