package cn.quantgroup.big.stms.common.aviator.ext.function;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorLong;
import com.googlecode.aviator.runtime.type.AviatorObject;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;

/**
 * 

 * <p>
 * description: 计算指定日期与当前日期相差天数
 * </p>
 * 
 * @author rong.yang/阳荣
 *
 */
public class DaysDiffFunction extends AbstractFunction {

	@Override
	public AviatorObject call(Map<String, Object> env, AviatorObject date) {
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
		String sd1 = FunctionUtils.getStringValue(date, env);
		if(null == sd1 || 0 == sd1.trim().length()) {
			throw new ExpressionRuntimeException(getName() + "函数参数不能为空！");
		}

		LocalDate date1 = LocalDate.parse(sd1, formatter);
		long days = ChronoUnit.DAYS.between(date1, LocalDate.now());

		return AviatorLong.valueOf(days);
	}

	@Override
	public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
		String sd1 = FunctionUtils.getStringValue(arg1, env);
		if(null == sd1 || 0 == sd1.trim().length()) {
			throw new ExpressionRuntimeException(getName() + "函数参数不能为空！");
		}
		
		String sd2 = FunctionUtils.getStringValue(arg2, env);
		if(null == sd2 || 0 == sd2.trim().length()) {
			throw new ExpressionRuntimeException(getName() + "函数参数不能为空！");
		}
		

		LocalDate date1 = LocalDate.parse(sd1, formatter);
		LocalDate date2 = LocalDate.parse(sd2, formatter);
		long days = ChronoUnit.DAYS.between(date1, date2);
		
		return AviatorLong.valueOf(days);
	}

	public String getName() {
		return "date.daysDiff";
	}

	public static void main(String[] args) {
		AviatorEvaluator.addFunction(new DaysDiffFunction());

		String expression = "date.daysDiff(date)";
		Map env = new HashMap();
		env.put("date", "2019-10-01");
		
		Expression ex = AviatorEvaluator.compile(expression, true);
		Object obj = ex.execute(env);
		System.out.println(obj);
		
		Object rs = AviatorEvaluator.execute("date.daysDiff(date)", env);
		System.out.println(rs);

	}

}
