package org.example.service;

import org.example.jpa.entity.UserEntity;
import org.example.jpa.repository.UserRepository;
import org.example.http.UserRequestData;
import cn.quant.spring.util.IdentitySequencer;
import cn.quant.spring.util.RandomSequencer;
import org.springframework.stereotype.Service;

import javax.inject.Inject;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * Created by hechao on 2020/2/17.
 */
@Service
public class JpaService {

    @Inject
    private UserRepository userRepository;

    @Inject
    private IdentitySequencer identitySequencer;

    public UserEntity findOne(Long id){
        return userRepository.findById(id).orElse(null);
    }

    public UserEntity save(UserRequestData request){
        UserEntity userEntity = new UserEntity()
                .userId(identitySequencer.nextId())
                .userName(request.getUserName())
                .date(LocalDate.now())
                .dateTime(LocalDateTime.now());
        userEntity.setPartitionKey(RandomSequencer.next(6, 2, 1000));
        return userRepository.save(userEntity);
    }

}
