package org.example.rest;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.example.mybatis.entity.Person;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@RestController
@RequestMapping("rule/person")
public class PersonRuleController {

    @Autowired
    private KieContainer kieContainer;

    @PostMapping("one")
    public void fireAllRules4One(@RequestBody Person person) {
        KieSession kSession = kieContainer.newKieSession();

        System.out.println(person);
        try {
            StringBuilder result = new StringBuilder();
            /*package部分*/
            result.append("package rule;\r\n");
            result.append("\r\n");

            /*导包部分*/
            result.append("import java.util.List;\r\n");
            result.append("\r\n");

            /*规则申明部分*/
            result.append("rule \"32353242\"\r\n");

            /*规则属性部分*/

            /*规则条件部分*/
            result.append("\twhen\r\n");
            result.append("\t\teval(true)\r\n");

            /*规则结果部分*/
            result.append("\tthen\r\n");
            result.append("\t\tSystem.out.println(\"动态加载的规则被触发了\");\r\n");

            /*规则结束*/
            result.append("end\r\n");
            StringBuilder result1 = new StringBuilder();
            /*package部分*/
            result1.append("package rule;\r\n");
            result1.append("\r\n");

            /*导包部分*/
            result1.append("import java.util.List;\r\n");
            result1.append("\r\n");

            /*规则申明部分*/
            result1.append("rule \"323532423333\"\r\n");

            /*规则属性部分*/

            /*规则条件部分*/
            result1.append("\twhen\r\n");
            result1.append("\t\teval(true)\r\n");

            /*规则结果部分*/
            result1.append("\tthen\r\n");
            result1.append("\t\tSystem.out.println(\"动态加载的规则被触发了2\");\r\n");

            /*规则结束*/
            result1.append("end\r\n");
            kSession.insert(person);
            List<String> resultList = new ArrayList<>();
            resultList.add(result.toString());
            resultList.add(result1.toString());
            getKieSessionFromDrl(resultList);
            int rulesFired = kSession.fireAllRules();
            System.out.println(rulesFired);
        } catch (Exception e) {

        } finally {
            kSession.dispose();
        }
    }

    @PostMapping("list")
    public void fireAllRules4List(@RequestBody List<Person> persons) {
        KieSession kSession = kieContainer.newKieSession();
        try {
            for (Person person : persons) {
                kSession.insert(person);
            }
            kSession.fireAllRules();
        } finally {
            kSession.dispose();
        }
    }

    public Date addDays(Date date, int addDays) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        rightNow.add(Calendar.DATE, addDays);
        return rightNow.getTime();
    }

    public static String dateFormat(Date date) {
        try {
            SimpleDateFormat DateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return DateFormat.format(date);
        } catch (Exception e) {
            System.out.println("123");
        }
        return "";
    }

    /**
     * 由从数据库里面读出的drl构建KieSession
     * @param drl
     * @return
     * @throws UnsupportedEncodingException
     */
    public static KieSession getKieSessionFromDrl(List<String> drlList) throws UnsupportedEncodingException {
        KieSession tempKieSession = null;
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String drl : drlList) {
            kb.add(ResourceFactory.newByteArrayResource(drl.getBytes("utf-8")), ResourceType.DRL);
        }
        if (kb.hasErrors()) {
            String errorMessage = kb.getErrors().toString();
            System.out.println("规则语法异常---\n"+errorMessage);
            return null;
        }
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        kBase.addPackages(kb.getKnowledgePackages());
        tempKieSession = kBase.newKieSession();
        tempKieSession.fireAllRules();
        tempKieSession.dispose();
        return tempKieSession;
    }


}