package org.example.jpa.entity;

import cn.quant.spring.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * Created by hechao on 2020/2/13.
 */
@Entity
@Table(name = "user")
public class UserEntity extends AuditedEntity implements Serializable {
    private static final long serialVersionUID = 4871312362433000454L;

    @Id
    @Column(name = "USER_ID", nullable = false, updatable = false)
    private Long userId;

    @Column(name = "USER_NAME", nullable = false, length = 36)
    private String userName;

    @Column(name = "DATE", nullable = true, length = 8)
    private LocalDate date;

    @Column(name = "DATE_TIME", nullable = true, length = 19)
    private LocalDateTime dateTime;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public LocalDate getDate() {
        return date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public LocalDateTime getDateTime() {
        return dateTime;
    }

    public void setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserEntity that = (UserEntity) o;
        return Objects.equals(userId, that.userId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userId);
    }

    @Override
    public String persistenceKey() {
        return StringUtils.toDelimitedString(UserEntity.class.getSimpleName(), userId);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("UserEntity{");
        sb.append("userId=").append(userId);
        sb.append(", userName='").append(userName).append('\'');
        sb.append(", date=").append(date);
        sb.append(", dateTime=").append(dateTime);
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }

    public UserEntity userId(Long userId) {
        this.userId = userId;
        return this;
    }

    public UserEntity userName(String userName) {
        this.userName = userName;
        return this;
    }

    public UserEntity date(LocalDate date) {
        this.date = date;
        return this;
    }

    public UserEntity dateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }
}
