package org.example.jpa.entity;

import org.example.support.AuditorAwareHandler;
import cn.quant.spring.data.jpa.entity.OptimisticEntity;
import cn.quant.spring.data.jpa.entity.PartitionEntity;
import org.hibernate.envers.Audited;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.EntityListeners;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;

/**
 * <p><b>Enable Audited Annotation:</b><br/>
 * <code>@org.hibernate.envers.Audited</code><br/>
 * <code>@javax.persistence.EntityListeners(AuditingEntityListener.class)</code><br/>
 * <code>@javax.persistence.MappedSuperclass</code><br/>
 * </p>
 * Created by hechao on 2020/2/13.
 * @see AuditorAwareHandler
 */
@Audited
@EntityListeners(AuditingEntityListener.class)
@MappedSuperclass
public abstract class AuditedEntity extends PartitionEntity implements Serializable {
    private static final long serialVersionUID = 7857933536111031118L;
}