package org.example;

import java.util.Arrays;

import org.example.mybatis.entity.Person;
import org.example.rest.PersonRuleController;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;


@SpringBootTest
public class PersonRuleControllerTest {

    @Autowired
    PersonRuleController controller;

    @Test
    public void testOnePerson() {
        Person bob = new Person();
        bob.setName("bob");

        controller.fireAllRules4One(bob);
    }

    @Test
    public void testTwoPerson() {
        Person bob = new Person();
        bob.setAge(33);

        Person other = new Person();
        other.setAge(88);

        controller.fireAllRules4List(Arrays.asList(bob, other));
    }
}
