package cn.quantgroup.exceptionhandler;

import cn.quantgroup.properties.ThrErrProProperties;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author ：dongjianhua
 * @date ：Created in 2021/5/14 14:34
 * @description：
 * @modified By：
 * @version:
 */
@Slf4j
public class DefaultDingDingExceptionHandler implements SentryExceptionHandler {
    private final String dingDingHost = "https://oapi.dingtalk.com/robot/send?access_token=";

    private ThrErrProProperties proProperties;
    OkHttpClient client;

    private final String dingDingUrl;

    public DefaultDingDingExceptionHandler(ThrErrProProperties proProperties) {
        this.proProperties = proProperties;
        this.client = new OkHttpClient();
        this.dingDingUrl = dingDingHost.concat(proProperties.getDingDingToken());
    }

    @Override
    public void handle(Exception e) {

        Map<String, Object> result = new HashMap<String, Object>();
        result.put("msgtype", "markdown");

        Map<String, Object> markdown = new HashMap<String, Object>();
        markdown.put("title", "sentry失效转钉钉告警");


        markdown.put("text", e.getMessage());
        result.put("markdown", markdown);

        String s = JSON.toJSONString(result);
        try {
            MediaType mediaType = MediaType.parse("application/json");
            RequestBody body = RequestBody.create(mediaType, s);
            Request request = new Request.Builder()
                    .url(dingDingUrl)
                    .post(body)
                    .addHeader("content-type", "application/json")
                    .build();

            Response response = client.newCall(request).execute();
        } catch (IOException e2) {
        }
        /**
         *
         */
        log.info("sentry异常了现在用DIngding进行告警");
    }
}
