package cn.quantgroup.config;

import io.sentry.connection.Connection;
import io.sentry.connection.ConnectionException;
import io.sentry.connection.EventSendCallback;
import io.sentry.event.Event;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;

/**
 * @author ：dongjianhua
 * @date ：Created in 2021/5/14 14:01
 * @description：
 * @modified By：
 * @version:
 */
@Slf4j
public class ThrErrAsyncConnectionWarp implements Connection {
    private final Connection connection ;
    private final SentryExceptionHandler handler ;

     ThrErrAsyncConnectionWarp(Connection connection,SentryExceptionHandler handler){
        this.connection = connection;
        this.handler = handler;
    }
    @Override
    public void send(Event event) throws ConnectionException {
        try {
            log.info("要异常了");

            connection.send(event);
        }catch (Exception e){
            handler.handle(e);
            throw e;
        }
    }

    @Override
    public void addEventSendCallback(EventSendCallback eventSendCallback) {
        connection.addEventSendCallback(eventSendCallback);
    }

    @Override
    public void close() throws IOException {
        connection.close();
    }
}
