package cn.quantgroup.config;

import cn.quantgroup.exceptionhandler.SentryExceptionHandler;
import io.sentry.connection.Connection;
import io.sentry.connection.ConnectionException;
import io.sentry.connection.EventSendCallback;
import io.sentry.event.Event;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;

/**
 * @author ：dongjianhua
 * @date ：Created in 2021/5/14 14:01
 * @description：
 * @modified By：
 * @version:
 */
@Slf4j
public class ThrErrAsyncConnectionWarp implements Connection {
    private final Connection connection;
    private final SentryExceptionHandler handler;

    ThrErrAsyncConnectionWarp(Connection connection, SentryExceptionHandler handler) {
        this.connection = connection;
        this.handler = handler;
    }

    @Override
    public void send(Event event) throws ConnectionException {
        try {
            connection.send(event);
        } catch (Exception e) {
            log.warn("sentry调用异常将使用自定义的handler处理异常!", e);
            handler.handle(e);
            throw e;
        }
    }

    @Override
    public void addEventSendCallback(EventSendCallback eventSendCallback) {
        connection.addEventSendCallback(eventSendCallback);
    }

    @Override
    public void close() throws IOException {
        connection.close();
    }
}
