package cn.quantgroup.config;


import cn.quantgroup.properties.ThrErrProProperties;
import cn.quantgroup.exceptionhandler.DefaultDingDingExceptionHandler;
import cn.quantgroup.exceptionhandler.SentryExceptionHandler;
import cn.quantgroup.sentry.config.SentryConstant;
import cn.quantgroup.sentry.config.SentryProperties;
import io.sentry.Sentry;
import io.sentry.SentryClient;
import io.sentry.SentryClientFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author ：dongjianhua
 * @date ：Created in 2021/5/14 9:53
 * @description：
 * @modified By：
 * @version:
 */
@Slf4j
@ConditionalOnProperty(
        name = {"sentry.dsn"},
        prefix = "threrr"
)
@Configuration
@EnableConfigurationProperties({SentryProperties.class,ThrErrProProperties.class})
public class SentryDingdingConfiguration {

    @Autowired
    private SentryProperties properties;

    @Autowired
    private ThrErrProProperties thrErrProProperties;
    /**
     * 注入不用是保证先初始化SentryClient
     */
    @Autowired
    private SentryClient sentryClient;

    @ConditionalOnProperty(
            name = {"sentry.dsn","threrr"}
    )
    @Bean("thrErrSentryClient")
    public SentryClient thrErrSentryClient() {
        log.info("init sentry client... dsn:{}", this.properties.getDsn());
        SentryExceptionHandler sentryDingdingExceptionHandler = getSentryDingdingExceptionHandler();
        SentryClientFactory sentryClientFactory = new ThrErrSentryClientFactory(sentryDingdingExceptionHandler);
        SentryClient sentryClient = Sentry.init(this.properties.getDsn(), sentryClientFactory);
        String[] tagArr;
        String[] var3;
        int var4;
        int var5;
        String tag;
        if (StringUtils.isNotBlank(this.properties.getMdcTags())) {
            tagArr = this.properties.getMdcTags().split(",");
            var3 = tagArr;
            var4 = tagArr.length;

            for(var5 = 0; var5 < var4; ++var5) {
                tag = var3[var5];
                if (StringUtils.isNotBlank(tag)) {
                    sentryClient.addMdcTag(tag);
                }
            }
        }

        if (StringUtils.isNotBlank(this.properties.getMsgTags())) {
            tagArr = this.properties.getMsgTags().split(",");
            var3 = tagArr;
            var4 = tagArr.length;

            for(var5 = 0; var5 < var4; ++var5) {
                tag = var3[var5];
                if (StringUtils.isNotBlank(tag)) {
                    SentryConstant.addMsgTag(tag);
                }
            }
        }

        return sentryClient;
    }

    private SentryExceptionHandler getSentryDingdingExceptionHandler(){
        String exceptionHandlerFactoryClassName = thrErrProProperties.getExceptionHandlerClassName();
        if(null != exceptionHandlerFactoryClassName){
            //todo 待完善自定义
        }
        return new DefaultDingDingExceptionHandler(thrErrProProperties);
    }
}
