package cn.quantgroup.cashloanflowboss.api.role.entity.boss;

import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import com.fasterxml.jackson.core.type.TypeReference;

import javax.persistence.AttributeConverter;
import java.util.List;
import java.util.Objects;

/**
 * Created by WeiWei on 2019/8/9.
 */
public class PermissionListConverter implements AttributeConverter<List<Permission>, String> {

    @Override
    public String convertToDatabaseColumn(List<Permission> permissions) {
        return JSONTools.serialize(permissions);
    }

    @Override
    public List<Permission> convertToEntityAttribute(String data) {
        return Objects.nonNull(data) && !data.isEmpty() ? JSONTools.deserialize(data, new TypeReference<List<Permission>>() {}) : null;
    }

}
