package cn.quantgroup.cashloanflowboss.spi.jolyne;

import cn.quantgroup.cashloanflowboss.spi.clotho.service.ClothoCenter;
import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "JolyneServiceCenter", url = "http://192.168.4.156:9001/executeSQL/{{NAMESPACE}}", fallback = JolyneCenter.Fallback.class)
public interface JolyneCenter {
  @PostMapping(value = "/xyqb", consumes = "application/json")
  String cancel(@RequestParam("json") String cancelData);

  @Component
  class Fallback implements JolyneCenter {

    @Override
    public String cancel(String cancelData) {
      return null;
    }
  }
}
