package cn.quantgroup.cashloanflowboss.api.order.controller;

import cn.quantgroup.cashloanflowboss.api.order.model.ApproveVo;
import cn.quantgroup.cashloanflowboss.api.order.model.OrderVo;
import cn.quantgroup.cashloanflowboss.api.order.service.OrderService;
import cn.quantgroup.cashloanflowboss.core.annotation.ChannelIdInit;
import cn.quantgroup.cashloanflowboss.core.annotation.CheckChannelRole;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * function:
 * date: 2019/8/8
 * @author: suntao
 */

@RestController
@RequestMapping("/order")
public class OrderController {


    @Autowired
    private OrderService orderService;

    /**
     * 订单查询接口
     * @param channelId
     * @param channelOrderNumber
     * @param pageNumber
     * @param pageSize
     * @return
     */
    @ChannelIdInit
    @CheckChannelRole
    @GetMapping("/info")
    public Result getOrders(Long channelId, String channelOrderNumber, Integer pageNumber, Integer pageSize) {
        return Result.buildSuccess(orderService.getOrders(channelId, channelOrderNumber, pageNumber, pageSize));
    }


    /**
     * 审批接口
     * @param approveVo
     * @return
     */
    @ChannelIdInit
    @PostMapping("/approve")
    public Result approveOpt(@RequestBody @Valid ApproveVo approveVo) {
        return Result.buildSuccess(orderService.approveOpt(approveVo));
    }

    @PostMapping(value = "/cancel/loan",consumes = "application/json")
    public Result cancel(@RequestBody @Valid OrderVo orderVo) {
        return Result.buildSuccess(orderService.cancel(orderVo));
    }
}
