package cn.quantgroup.cashloanflowboss.api.order.service;
import java.util.Date;

import cn.quantgroup.cashloanflowboss.api.channel.entity.ChannelConf;
import cn.quantgroup.cashloanflowboss.api.channel.repository.ChannelConfRepository;
import cn.quantgroup.cashloanflowboss.api.channel.util.ChannelConfUtil;
import cn.quantgroup.cashloanflowboss.api.order.entity.Order;
import cn.quantgroup.cashloanflowboss.api.order.model.ApproveVo;
import cn.quantgroup.cashloanflowboss.api.order.model.OrderVo;
import cn.quantgroup.cashloanflowboss.api.order.repository.OrderRepository;
import cn.quantgroup.cashloanflowboss.api.order.util.OrderUtil;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.ClfOrderMappingRepository;
import cn.quantgroup.cashloanflowboss.spi.clotho.service.ClothoCenter;
import cn.quantgroup.cashloanflowboss.spi.jolyne.JolyneCenter;
import cn.quantgroup.cashloanflowboss.spi.user.service.XyqbUserService;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import cn.quantgroup.user.retbean.XUser;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.Predicate;
import java.util.*;

/**
 * function:
 * date: 2019/8/8
 *
 * @author: suntao
 */

@Slf4j
@Service
public class OrderService {

    @Autowired
    private ChannelConfRepository channelConfRepository;
    @Autowired
    private OrderRepository orderRepository;

    @Autowired
    private ClfOrderMappingRepository clfOrderMappingRepository;
    @Autowired
    private XyqbUserService xyqbUserService;
    @Autowired
    private ClothoCenter clothoCenter;
    @Autowired
    private JolyneCenter jolyneCenter;



    public Page<OrderVo> getOrders(Long channelId, String channelOrderNo, Integer pageNumber, Integer pageSize) {
        Page<ClfOrderMapping> page = this.clfOrderMappingRepository.findAll((root, criteriaQuery, criteriaBuilder) -> {

            List<Predicate> predicates = new ArrayList<>();

            // 指定渠道号
            if (Objects.nonNull(channelId)) {
                predicates.add(criteriaBuilder.equal(root.get("registeredFrom"), channelId.longValue()));
            }
            if (StringUtils.isNotEmpty(channelOrderNo)) {
                predicates.add(criteriaBuilder.equal(root.get("channelOrderNo"), channelOrderNo));
            }

            // 设置查询条件
            criteriaQuery.where(criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()])));
            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));

            return criteriaQuery.getRestriction();

        }, new PageRequest(pageNumber, pageSize));

        return page.map(it-> {
            OrderVo orderVo = new OrderVo();
            orderVo.setId(it.getId());
            orderVo.setChannelId(it.getRegisteredFrom());
            orderVo.setChannelOrderNumber(it.getChannelOrderNo());
            orderVo.setCreatedAt(it.getCreatedAt().getTime());

            OrderVo.OptButton button = new OrderVo.OptButton();
            button.setAction(OrderVo.OptButtonAction.audit.name());
            button.setName(OrderVo.OptButtonAction.audit.getDesc());

            List<OrderVo.OptButton> buttonList = new ArrayList<>();
            buttonList.add(button);

            orderVo.setStatus(OrderVo.OptButtonAction.audit.getDesc());
            orderVo.setOpt(buttonList);
            orderVo.setMessage("");
            return orderVo;
        });
    }

    public Boolean approveOpt(ApproveVo approveVo) {

        ClfOrderMapping orderMapping = clfOrderMappingRepository.findByChannelOrderNoLastOne(approveVo.getChannelOrderNumber());
        if (orderMapping == null) {
            log.info("approveOpt,审批失败，无订单 channelOrderNumber={}", approveVo.getChannelOrderNumber());
            return false;
        }

        if (Application.getPrincipal().isChannel() && !Application.getPrincipal().isSameChannel(orderMapping.getRegisteredFrom())) {
            log.info("approveOpt,审批失败，不是该渠道订单无法审批 channelOrderNumber={}", approveVo.getChannelOrderNumber());
            return false;
        }

        XUser xUser = xyqbUserService.findXUserById(orderMapping.getQgUserId());
        if (xUser == null) {
            log.info("approveOpt,审批失败，未找到用户 channelOrderNumber={}", approveVo.getChannelOrderNumber());
            return false;
        }

        ChannelConf channelConf = channelConfRepository.getByChannelId(orderMapping.getRegisteredFrom());
        if (channelConf == null) {
            log.info("approveOpt,审批失败，boss渠道配置为空 channelOrderNumber={}", approveVo.getChannelOrderNumber());
            return false;
        }

        // 额度有效期
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.DAY_OF_YEAR, 7);


        Integer fundId = ChannelConfUtil.getFundIdByType(approveVo.getFundType(), channelConf);
        // 资方 及 期数额度规则
        String fundFormat = String.format(OrderUtil.financeProductsFormat, approveVo.getAmount(), approveVo.getAmount(),
                approveVo.getPeriod(), fundId);


        Order order = new Order();
        order.setChannelOrderNumber(approveVo.getChannelOrderNumber());
        order.setCreditNumber(orderMapping.getApplyNo());
        order.setChannelId(orderMapping.getRegisteredFrom());
        order.setFundId(fundId);
        order.setFundType(approveVo.getFundType());
        order.setCreateTime(new Date());
        order.setUpdateTime(new Date());
        orderRepository.save(order);



        Map<String, Object> data = new HashMap<>(16);
        data.put("code", 0);
        data.put("msg", "success");
        data.put("bizChannel", orderMapping.getRegisteredFrom());
        data.put("uuid", xUser.getUuid());
        data.put("bizNo", orderMapping.getApplyNo());
        data.put("bizType", channelConf.getBizType());
        data.put("auditResult", approveVo.getIsPass());
        data.put("amount", approveVo.getAmount());
        data.put("deadLine", calendar.getTime().getTime());
        data.put("financeProducts", fundFormat);

        // 发起审批
        String approveResult = clothoCenter.approve(data);
        if ("success".equals(approveResult)) {
            log.info("审批申请成功，channelOrderNumber={}", orderMapping.getChannelOrderNo());
            return true;
        } else {
            log.info("审批申请失败，channelOrderNumber={}，requestParam={}", orderMapping.getChannelOrderNo(), JSONTools.serialize(data));
            return false;
        }
    }

    public boolean cancel(OrderVo orderVo){
        ClfOrderMapping orderMapping = clfOrderMappingRepository.findByChannelOrderNoLastOne(orderVo.getChannelOrderNumber());
        if (orderMapping == null) {
            log.info("cancel,关单失败，无订单 channelOrderNumber={}", orderVo.getChannelOrderNumber());
            return false;
        }

        XUser xUser = xyqbUserService.findXUserById(orderMapping.getQgUserId());
        if (xUser == null) {
            log.info("cancel,关单失败，未找到用户 channelOrderNumber={}", orderVo.getChannelOrderNumber());
            return false;
        }
        Long userId = xUser.getId();
        ConcurrentMap<Object, Object> data = Maps.newConcurrentMap();
        ArrayList<Object> cancel_list = Lists.newArrayList();
        cancel_list.add("update xyqb.quota_credit set is_active=0 where user_id="+userId);
        cancel_list.add("update xyqb.quota_account set is_active=0 where user_id="+userId);
        cancel_list.add("update xyqb.loan_application_history set progress=16 where user_id="+userId);
        cancel_list.add("update xyqb.loan_application_history set is_active=0 where user_id="+userId);
        cancel_list.add("delete from apply_quota_record where user_id="+userId);
        cancel_list.add("delete from user_operation_history where user_id="+userId);
        data.put("sql",cancel_list);
        String cancel_result = jolyneCenter.cancel(JSONTools.serialize(data));
        return "success".equals(cancel_result);
    }
}
