package cn.quantgroup.cashloanflowboss.spi.xyqb.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;


/**
 * Created with suntao on 2018/12/26
 */
@Slf4j
@Service
public class OrderStatusQueryService {
//
//    @Autowired
//    private XyqbService xyqbService;
//    @Autowired
//    private IRepaymentPlanService repaymentPlanService;
//    @Autowired
//    private ILoanApplicationManifestHistoryService loanApplicationManifestHistoryService;
//    @Autowired
//    private IRepaymentPlanService xyqbRepaymentPlanService;
//
//
//    /**
//     * 只查询订单状态，不查询每个状态对应的数据，推荐使用
//     * @param queryModel
//     * @return
//     */
//    public OrderStatusQueryResultOnlyStatus queryOrderStatusKaNoticeType(OrderStatusQueryModel queryModel) {
//        LoanOrderMapping orderMapping = queryModel.getOrderMapping();
//        if (orderMapping == null) {
//            log.info("[orderStatusQueryServiceImpl_queryOrderStatusKaNoticeType]参数异常，orderMapping空");
//            return null;
//        }
//        final Long channelId = orderMapping.getRegisteredFrom();
//        final String channelOrderNo = orderMapping.getChannelOrderNo();
//        final String channelPaymentNo = orderMapping.getChannelPaymentNo();
//        final String applyNo = orderMapping.getApplyNo();
//        final Long loanId = orderMapping.getLoanId();
//        final OrderStatusQueryModel.QueryType queryType = queryModel.getQueryType();
//
//        if (StringUtils.isEmpty(channelOrderNo) && StringUtils.isEmpty(channelPaymentNo) && StringUtils.isEmpty(applyNo) && loanId == null) {
//            log.info("[orderStatusQueryServiceImpl_queryOrderStatusKaNoticeType]参数异常，channelOrderNo={},channelPaymentNo={},applyNo={},loanId={}", channelOrderNo, channelPaymentNo, applyNo, loanId);
//            return null;
//        }
//        if (channelId == null) {
//            log.info("[orderStatusQueryServiceImpl_queryOrderStatusKaNoticeType]参数异常，channelId 为空");
//            return null;
//        }
//        OrderStatusQueryResultOnlyStatus queryResult = new OrderStatusQueryResultOnlyStatus();
//        if (queryType != null) {
//            // 查询条件不为空  按照查询条件查询
//            switch (queryType) {
//                case APPROVE:
//                    return loadApproveOnlyStatus(queryResult, orderMapping);
//                case WITHDRAW:
//                    return loadDrawOnlyStatus(queryResult, orderMapping);
//                case PAY:
//                    return loadPayOnlyStatus(queryResult, orderMapping);
//                case ALL_REPAID:
//                case CANCEL_LOAN:
//                case CANCEL_AFTER_LOAN:
//                    return loadFinalStatusOnlyStatus(queryResult, orderMapping);
//                default:
//                    return queryResult;
//            }
//        }
//
//        OrderStatusQueryResultOnlyStatus loadFinalStatus = loadFinalStatusOnlyStatus(queryResult, orderMapping);
//        if (loadFinalStatus == null) {
//            // 加载前面的状态
//            return loadPayOnlyStatus(queryResult, orderMapping);
//        } else {
//            return loadFinalStatus;
//        }
//    }
//
//    @Override
//    public Boolean finalStatusQuery(String applyNo, Long loanId) {
//        LoanOrderMapping orderMapping = new LoanOrderMapping();
//        orderMapping.setApplyNo(applyNo);
//        orderMapping.setLoanId(loanId);
//        final Boolean isFinalStatus = loadFinalStatus(new OrderStatusQueryResult(), orderMapping);
//        if (isFinalStatus) {
//            // 状态
//            log.error("[finalStatusQuery]订单终态查询，结果：终态。applyNo={},loanId={}", applyNo, loanId);
//        } else {
//            // 非终态
//            log.info("[finalStatusQuery]订单终态查询，结果：非终态。applyNo={},loanId={}", applyNo, loanId);
//        }
//        return isFinalStatus;
//    }
//
//
//    /**
//     * 授信结果查询
//     * @param queryModel
//     * @return true 授信成功；false:授信失败,null:授信中
//     */
//    @Override
//    public OrderStatusQueryResult.CreditStatus queryCreditStatus(OrderStatusQueryModel queryModel) {
//        LoanOrderMapping orderMapping = queryModel.getOrderMapping();
//        if (orderMapping == null) {
//            log.info("[orderStatusQueryServiceImpl_queryOrderStatus]参数异常，orderMapping空");
//            return null;
//        }
//        final Long channelId = orderMapping.getRegisteredFrom();
//        final String channelOrderNo = orderMapping.getChannelOrderNo();
//        final String applyNo = orderMapping.getApplyNo();
//
//        if (StringUtils.isEmpty(channelOrderNo) && StringUtils.isEmpty(applyNo)) {
//            log.info("[orderStatusQueryServiceImpl_queryOrderStatus]参数异常，channelOrderNo={},,applyNo={}", channelOrderNo, applyNo);
//            return null;
//        }
//        if (channelId == null) {
//            log.info("[orderStatusQueryServiceImpl_queryOrderStatus]参数异常，channelId 为空");
//            return null;
//        }
//        Optional<QuotaCreditInfo> quotaCreditInfoOptional = xyqbService.queryQuotaCreditInfo(applyNo);
//        if (!quotaCreditInfoOptional.isPresent()) {
//            return null;
//        }
//        final QuotaCreditInfo quotaCreditInfo = quotaCreditInfoOptional.get();
//        // '0:发起授信;1:授信成功;2:授信失败;3:授信处理中',
//        if (1 == quotaCreditInfo.getCreditStatus()) {
//            return OrderStatusQueryResult.CreditStatus.SUCCESS;
//        } else if (2 == quotaCreditInfo.getCreditStatus()) {
//            return OrderStatusQueryResult.CreditStatus.FAIL;
//        } else {
//            return OrderStatusQueryResult.CreditStatus.PROGRESSING;
//        }
//    }
//
//
//    /**
//     * 查询订单状态 并查询每个状态对应的数据 不推荐使用
//     * @param queryModel
//     * @return
//     */
//    @Override
//    public OrderStatusQueryResult queryOrderStatus(OrderStatusQueryModel queryModel) {
//        LoanOrderMapping orderMapping = queryModel.getOrderMapping();
//        if (orderMapping == null) {
//            log.info("[orderStatusQueryServiceImpl_queryOrderStatus]参数异常，orderMapping空");
//            return null;
//        }
//        final Long channelId = orderMapping.getRegisteredFrom();
//        final String channelOrderNo = orderMapping.getChannelOrderNo();
//        final String channelPaymentNo = orderMapping.getChannelPaymentNo();
//        final String applyNo = orderMapping.getApplyNo();
//        final Long loanId = orderMapping.getLoanId();
//        final OrderStatusQueryModel.QueryType queryType = queryModel.getQueryType();
//
//        if (StringUtils.isEmpty(channelOrderNo) && StringUtils.isEmpty(channelPaymentNo) && StringUtils.isEmpty(applyNo) && loanId == null) {
//            log.info("[orderStatusQueryServiceImpl_queryOrderStatus]参数异常，channelOrderNo={},channelPaymentNo={},applyNo={},loanId={}", channelOrderNo, channelPaymentNo, applyNo, loanId);
//            return null;
//        }
//        if (channelId == null) {
//            log.info("[orderStatusQueryServiceImpl_queryOrderStatus]参数异常，channelId 为空");
//            return null;
//        }
//        OrderStatusQueryResult queryResult = new OrderStatusQueryResult();
//        if (queryType != null) {
//            // 查询条件不为空  按照查询条件查询
//            switch (queryType) {
//                case APPROVE:
//                    loadApprove(queryResult, orderMapping);
//                    return queryResult;
//                case WITHDRAW:
//                    loadDraw(queryResult, orderMapping);
//                    return queryResult;
//                case PAY:
//                    loadPay(queryResult, orderMapping);
//                    return queryResult;
//                case ALL_REPAID:
//                case CANCEL_LOAN:
//                case CANCEL_AFTER_LOAN:
//                    loadFinalStatus(queryResult, orderMapping);
//                    return queryResult;
//                default:
//                    return queryResult;
//            }
//        }
//
//        Boolean loadFinalStatus = loadFinalStatus(queryResult, orderMapping);
//        if (!loadFinalStatus) {
//            // 说明目前还不是终态
//            loadPay(queryResult, orderMapping);
//        }
//        return queryResult;
//    }
//
//    /**
//     * 审批状态加载
//     * @param queryResult
//     * @param orderMapping
//     * @return true:订单终态，false：订单还可以继续流转
//     */
//    private Boolean loadApprove(OrderStatusQueryResult queryResult, LoanOrderMapping orderMapping) {
//        if(StringUtils.isEmpty(orderMapping.getApplyNo())){
//            return false;
//        }
//        JsonResult jsonResultApprove = exService.queryApproveStatus(orderMapping.getApplyNo());
//        queryResult.setApplyNo(orderMapping.getApplyNo());
//        queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.APPROVE);
//        // 格式："2018-04-21 13:54:02"
//        String updateAt = String.valueOf(jsonResultApprove.getData());
//        Date date = DateUtil.dateStr2Date(updateAt, DateUtil.DATE_FORMAT_1);
//
//        if (jsonResultApprove.isSuccess()) {
//            Optional<QuotaInfo> quotaInfo = xyqbService.queryQuotaInfo(orderMapping.getQgUserId(), orderMapping.getRegisteredFrom());
//            if (!quotaInfo.isPresent()) {
//                queryResult.setUpdateTime(date);
//                queryResult.setApproveStatus(OrderStatusQueryResult.ApproveStatus.PROGRESSING);
//                log.info("[orderStatusQuery][loadApprove]审批状态查询加载，结果：审批状态成功,但是额度查询失败，视为审批中,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//                return false;
//            }
//            // 审批通过
//            queryResult.setApproveStatus(OrderStatusQueryResult.ApproveStatus.PASS);
//            BigDecimal maxAmount = quotaInfo.get().getRule().getMaxAmount();
//            int maxTerm = quotaInfo.get().getRule().getMaxAmountAndTerm().getMaxTerm();
//            OrderStatusQueryResult.LoanDetail loanDetail = new OrderStatusQueryResult.LoanDetail();
//            loanDetail.setApproveAmount(maxAmount);
//            loanDetail.setLoanTerm(maxTerm);
//            List<QuotaRepaymentPreview> quotaRepaymentPreviews = repaymentPlanService.trialRepaymentPlan(String.valueOf(orderMapping.getQgUserId()), ProductUtil.getProductId(orderMapping.getRegisteredFrom()),
//                    Constants.DECIMAL_FORMAT2.format(maxAmount), String.valueOf(maxTerm), orderMapping.getApplyNo(), orderMapping.getLoanId());
//            loanDetail.setQuotaRepaymentPreview(quotaRepaymentPreviews);
//            queryResult.setLoanDetail(loanDetail);
//            queryResult.setUpdateTime(DateUtil.dateStr2Date(String.valueOf(jsonResultApprove.getData()), DateUtil.DATE_FORMAT_1));
//            log.info("[orderStatusQuery][loadApprove]审批状态查询加载，结果：审批状态成功,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            return false;
//        } else if (Constants.APPROVE_FUND_ING_B_CODE.getKey().equals(jsonResultApprove.getBusinessCode())) {
//            // 待审批
//            queryResult.setUpdateTime(date);
//            queryResult.setApproveStatus(OrderStatusQueryResult.ApproveStatus.PROGRESSING);
//            log.info("[orderStatusQuery][loadApprove]审批状态查询加载，结果：审批状态审批中,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            return false;
//        } else if (Constants.APPROVE_FUND_FAIL_B_CODE.getKey().equals(jsonResultApprove.getBusinessCode())) {
//            // 未通过
//            queryResult.setApproveStatus(OrderStatusQueryResult.ApproveStatus.REFUSE);
//            queryResult.setUpdateTime(date);
//            log.info("[orderStatusQuery][loadApprove]审批状态查询加载，结果：审批未通过,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            return true;
//        } else if (Constants.LOAN_CANCEL_B_CODE.getKey().equals(jsonResultApprove.getBusinessCode())) {
//            // 借款取消
//            queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.CANCEL_LOAN);
//            queryResult.setUpdateTime(date);
//            queryResult.setApplyNo(orderMapping.getApplyNo());
//            log.info("[orderStatusQuery][loadApprove]审批状态查询加载，结果：借款取消,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            return true;
//        }
//        queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.UNKOWN);
//        log.info("[orderStatusQuery][loadApprove]审批状态查询加载，结果：未知,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//        return false;
//     }
//
//    /**
//     * 加载提现状态，不管当前状态是什么，都需要加载审批状态
//     * 方法必须 保证 1、是确定当前状态结束 或者 2、加载前置状态
//     * @return true:当前状态结束；false：当前状态加载前置状态
//     */
//    private void loadDraw(OrderStatusQueryResult queryResult, LoanOrderMapping orderMapping) {
//
//        // 先加载审批状态，填充OrderStatusQueryResult.LoanDetail(当状态是提现成功状态，OrderStatusQueryResult.LoanDetail也是有效的)
//        // 必须 先加载审批方法，否则状态会覆盖
//        loadApprove(queryResult, orderMapping);
//
//        final Long loanId = orderMapping.getLoanId();
//        if (loanId != null) {
//            queryResult.setLoanId(loanId);
//            XyqbLoanApplicationManifestHistory manifestHistory = loanApplicationManifestHistoryService.findByLoanApplicationHistoryId(loanId);
//            if (manifestHistory != null) {
//                // 提现成功状态
//                queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.DRAW);
//                queryResult.setDrawStatus(OrderStatusQueryResult.DrawStatus.SUCCESS);
//                OrderStatusQueryResult.DrawDetail drawDetail = new OrderStatusQueryResult.DrawDetail();
//                drawDetail.setXyqbLoanApplicationManifestHistory(manifestHistory);
//                queryResult.setDrawDetail(drawDetail);
//                queryResult.setUpdateTime(manifestHistory.getCreatedAt());
//                log.info("[orderStatusQuery][loadDraw]加载提现状态，结果：提现状态成功,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            } else {
//                log.info("[orderStatusQuery][loadDraw]加载提现状态，结果：提现状态成功,但是借款清单不存在，该状态异常，视为当前状态为审批状态,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            }
//        }
//    }
//
//    /**
//     * 方法必须 保证 1、是确定当前状态结束 或者 2、加载前置状态
//     * @return true:当前状态结束；false：当前状态加载前置状态
//     */
//    private Boolean loadPay(OrderStatusQueryResult queryResult, LoanOrderMapping orderMapping) {
//
//        final Long loanId = orderMapping.getLoanId();
//        if (loanId == null) {
//            // loanId=null, 调用 提现状态加载（前置状态）
//            log.info("[orderStatusQuery][loadPay]放款状态加载，结果：loanId=null,加载前置状态,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            loadDraw(queryResult, orderMapping);
//            return false;
//        }
//        queryResult.setLoanId(loanId);
//        Optional<QueryXyqbFundStatusResponse> queryXyqbFundStatusResponseOptional = xyqbRepaymentPlanService.queryFundStatus(orderMapping.getApplyNo(), loanId);
//        if (!queryXyqbFundStatusResponseOptional.isPresent()) {
//            log.info("[orderStatusQuery][loadPay]放款状态加载，结果：放款中，加载前置状态（提现状态）,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            loadDraw(queryResult, orderMapping);
//            return false;
//        }
//
//        QueryXyqbFundStatusResponse queryXyqbFundStatusResponse = queryXyqbFundStatusResponseOptional.get();
//        FundStatusEnum fundStatusEnum = queryXyqbFundStatusResponse.getStatus();
//        // 2018-09-26 08:47:13
//        queryResult.setUpdateTime(DateUtil.dateStr2Date(queryXyqbFundStatusResponse.getUpdatedAt(), DateUtil.DATE_FORMAT_1));
//
//        if (fundStatusEnum == null) {
//            log.info("[orderStatusQuery][loadPay]放款状态加载，结果：放款中，加载前置状态（提现状态）,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            loadDraw(queryResult, orderMapping);
//            return false;
//        }
//        switch (fundStatusEnum) {
//            case SUCC:
//                queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.PAY);
//                initPayDetail(queryResult, orderMapping);
//                return false;
//            case DEPOSITORY_SUCC:
//                queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.DEPOSITORY);
//                queryResult.setDepositoryStatus(OrderStatusQueryResult.DepositoryStatus.DEPOSITORY_SUCC);
//                initPayDetail(queryResult, orderMapping);
//                return false;
//            case FAIL:
//                // 失败
//                queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.PAY);
//                queryResult.setPayStatus(OrderStatusQueryResult.PayStatus.FAIL);
//                // 结束 当前状态 放款失败
//                log.info("[orderStatusQuery][loadPay]放款状态加载，结果：放款失败,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//                return true;
//            case DEPOSITORY_FAIL:
//                queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.DEPOSITORY);
//                queryResult.setDepositoryStatus(OrderStatusQueryResult.DepositoryStatus.DEPOSITORY_FAIL);
//                initPayDetail(queryResult, orderMapping);
//                return true;
//            case DEPOSITORY_HANDING:
//                // 视为放款成功
//                queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.PAY);
//                queryResult.setPayStatus(OrderStatusQueryResult.PayStatus.SUCCESS);
//                initPayDetail(queryResult, orderMapping);
//                return false;
//            case HANDING:
//                queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.PAY);
//                queryResult.setPayStatus(OrderStatusQueryResult.PayStatus.PROGRESSING);
//                // 待放款  调用 提现状态加载（前置状态）
//                log.info("[orderStatusQuery][loadPay]放款状态加载，结果：放款中，加载前置状态（提现状态）,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//                // 不能去查还款计划预览，xyqb报错
//                //loadDraw(queryResult, orderMapping);
//                return false;
//            default:
//                queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.PAY);
//                queryResult.setPayStatus(OrderStatusQueryResult.PayStatus.PROGRESSING);
//                // 待放款  调用 提现状态加载（前置状态）
//                log.info("[orderStatusQuery][loadPay]放款状态加载，结果：放款中，加载前置状态（提现状态）,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//                //loadDraw(queryResult, orderMapping);
//                return false;
//        }
//
//    }
//
//    private void initPayDetail(OrderStatusQueryResult queryResult, LoanOrderMapping orderMapping) {
//
//        XyqbLoanApplicationManifestHistory manifestHistory = loanApplicationManifestHistoryService.findByLoanApplicationHistoryId(orderMapping.getLoanId());
//        if (manifestHistory != null) {
//            queryResult.setPayStatus(OrderStatusQueryResult.PayStatus.SUCCESS);
//
//            OrderStatusQueryResult.PayDetail payDetail = new OrderStatusQueryResult.PayDetail();
//            payDetail.setPayAmount(manifestHistory.getContractLoanAmount());
//            payDetail.setTerm(manifestHistory.getContractTerm());
//            payDetail.setRepayAmount(manifestHistory.getTotalRepaymentAmount());
//            payDetail.setMouthlyAmount(manifestHistory.getMonthlyRepayment());
//            payDetail.setYearRate(manifestHistory.getAnnualInterestRate());
//            payDetail.setMouthlyRate(manifestHistory.getMonthlyInterestRate());
//
//            Optional<DepositoryBusiness> depositoryBusinessOptional = xyqbService.queryDepositoryBusiness(orderMapping.getApplyNo(), orderMapping.getLoanId());
//            if (depositoryBusinessOptional.isPresent()) {
//                Boolean withdrawType = depositoryBusinessOptional.get().getWithdrawType();
//                payDetail.setIsDepository(withdrawType == null ? false : withdrawType);
//            } else {
//                payDetail.setIsDepository(false);
//            }
//            queryResult.setPayDetail(payDetail);
//            queryResult.setRepaymentPlanViews(repaymentPlanService.queryRepaymentPlanFromXyqb(manifestHistory.getLoanApplicationHistoryId()));
//
//            // 结束 当前状态 放款成功
//            log.info("[orderStatusQuery][loadPay]放款状态加载，结果：放款成功,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//        } else {
//            queryResult.setPayStatus(OrderStatusQueryResult.PayStatus.PROGRESSING);
//            // 数据有误，试做前置状态对待，待放款  调用 提现状态加载（前置状态）
//            log.info("[orderStatusQuery][loadPay]放款状态加载，已经查出是放款成功，但是借款清单无记录，数据异常，加载前置状态（提现状态）,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            loadDraw(queryResult, orderMapping);
//        }
//    }
//
//    /**
//     * @return true:订单终态，false：订单还可以继续流转
//     */
//    private Boolean loadFinalStatus(OrderStatusQueryResult queryResult, LoanOrderMapping orderMapping) {
//        FinalStatusResponse finalStatusResponse = xyqbService.queryFinalStatus(orderMapping.getApplyNo(), orderMapping.getLoanId());
//        if (finalStatusResponse != null) {
//            if (FinalStatusEnum.LOAN_COMPLETE.equals(finalStatusResponse.getStatus())) {
//                // 结清终态
//                queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.ALL_REPAID);
//                queryResult.setUpdateTime(finalStatusResponse.getUpdatedAt());
//                queryResult.setApplyNo(orderMapping.getApplyNo());
//                log.info("[orderStatusQuery][loadFinalStatus]订单终态查询，结果：终态结清,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//                return true;
//            } else if (finalStatusResponse.getStatus().isCancelLoan()) {
//                // 借款取消
//                queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.CANCEL_LOAN);
//                queryResult.setUpdateTime(finalStatusResponse.getUpdatedAt());
//                queryResult.setApplyNo(orderMapping.getApplyNo());
//                log.info("[orderStatusQuery][loadFinalStatus]订单终态查询，结果：终态取消,status={},applyNo={},loanId={}", finalStatusResponse.getStatus().name(), orderMapping.getApplyNo(), orderMapping.getLoanId());
//                return true;
//            } else if (FinalStatusEnum.CANCEL_AFTER_LOAN.equals(finalStatusResponse.getStatus())) {
//                // 借款取消 贷后超时 取消
//                queryResult.setCurrentOrderStatus(OrderStatusQueryResult.CurrentOrderStatus.CANCEL_AFTER_LOAN);
//                queryResult.setUpdateTime(finalStatusResponse.getUpdatedAt());
//                queryResult.setApplyNo(orderMapping.getApplyNo());
//                log.info("[orderStatusQuery][loadFinalStatus]订单终态查询，结果：终态存管提现取消关闭,status={},applyNo={},loanId={}", finalStatusResponse.getStatus().name(), orderMapping.getApplyNo(), orderMapping.getLoanId());
//                return true;
//            }else {
//                log.info("[orderStatusQuery][loadFinalStatus]订单终态查询，结果：未知,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//                return false;
//            }
//        }
//        log.info("[orderStatusQuery][loadFinalStatus]订单终态查询，结果：未知,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//        return false;
//    }
//
//
//    // =======================================only status begin ====================================
//
//
//    private OrderStatusQueryResultOnlyStatus loadFinalStatusOnlyStatus(OrderStatusQueryResultOnlyStatus queryResult, LoanOrderMapping orderMapping) {
//        if (orderMapping.getLoanId() == null) {
//            log.info("[orderStatusQuery][OnlyStatus][loadFinalStatus]订单终态查询loanId为空，结果未知");
//            return null;
//        }
//        FinalStatusResponse finalStatusResponse = xyqbService.queryFinalStatus(orderMapping.getApplyNo(), orderMapping.getLoanId());
//        if (finalStatusResponse != null) {
//            if (FinalStatusEnum.LOAN_COMPLETE.equals(finalStatusResponse.getStatus())) {
//                // 结清终态
//                log.info("[orderStatusQuery][OnlyStatus][loadFinalStatus]订单终态查询，结果：终态结清,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//                queryResult.setKaNoticeType(KANoticeType.ALL_REPAID);
//                return queryResult;
//            } else if (finalStatusResponse.getStatus().isCancelLoan()) {
//                // 借款取消
//                queryResult.setKaNoticeType(KANoticeType.CANCEL_LOAN);
//                log.info("[orderStatusQuery][OnlyStatus][loadFinalStatus]订单终态查询，结果：终态取消,status={},applyNo={},loanId={}", finalStatusResponse.getStatus().name(), orderMapping.getApplyNo(), orderMapping.getLoanId());
//                return queryResult;
//            } else if (FinalStatusEnum.CANCEL_AFTER_LOAN.equals(finalStatusResponse.getStatus())) {
//                // 借款取消 贷后超时 取消
//                log.info("[orderStatusQuery][loadFinalStatus]订单终态查询，结果：终态存管提现取消关闭,status={},applyNo={},loanId={}", finalStatusResponse.getStatus().name(), orderMapping.getApplyNo(), orderMapping.getLoanId());
//                queryResult.setKaNoticeType(KANoticeType.CANCEL_AFTER_LOAN);
//                return queryResult;
//            }else {
//                log.info("[orderStatusQuery][OnlyStatus][loadFinalStatus]订单终态查询，结果：未知,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//                return null;
//            }
//        }
//        log.info("[orderStatusQuery][OnlyStatus][loadFinalStatus]订单终态查询，结果：未知,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//        return null;
//    }
//
//    private OrderStatusQueryResultOnlyStatus loadPayOnlyStatus(OrderStatusQueryResultOnlyStatus queryResult, LoanOrderMapping orderMapping) {
//        final Long loanId = orderMapping.getLoanId();
//        if (loanId == null) {
//            // loanId=null, 调用 提现状态加载（前置状态）
//            log.info("[orderStatusQuery][OnlyStatus][loadPay]放款状态加载，结果：loanId=null,加载前置状态,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            return loadDrawOnlyStatus(queryResult, orderMapping);
//        }
//        queryResult.setLoanId(loanId);
//        Optional<QueryXyqbFundStatusResponse> queryXyqbFundStatusResponseOptional = xyqbRepaymentPlanService.queryFundStatus(orderMapping.getApplyNo(), loanId);
//        if (!queryXyqbFundStatusResponseOptional.isPresent()) {
//            log.info("[orderStatusQuery][OnlyStatus][loadPay]放款状态加载，结果：放款中，加载前置状态（提现状态）,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            return loadDrawOnlyStatus(queryResult, orderMapping);
//        }
//
//        QueryXyqbFundStatusResponse queryXyqbFundStatusResponse = queryXyqbFundStatusResponseOptional.get();
//        FundStatusEnum fundStatusEnum = queryXyqbFundStatusResponse.getStatus();
//        // 2018-09-26 08:47:13
//        queryResult.setUpdateTime(DateUtil.dateStr2Date(queryXyqbFundStatusResponse.getUpdatedAt(), DateUtil.DATE_FORMAT_1));
//
//        if (fundStatusEnum == null) {
//            log.info("[orderStatusQuery][OnlyStatus][loadPay]放款状态加载，结果：放款中，加载前置状态（提现状态）,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//            return loadDrawOnlyStatus(queryResult, orderMapping);
//        }
//        switch (fundStatusEnum) {
//            case SUCC:
//                queryResult.setKaNoticeType(KANoticeType.FUND_SUCC);
//                return queryResult;
//            case DEPOSITORY_SUCC:
//                queryResult.setKaNoticeType(KANoticeType.FUND_WITHDRAW_SUCC);
//                return queryResult;
//            case FAIL:
//                // 失败
//                queryResult.setKaNoticeType(KANoticeType.FUND_FAIL);
//                log.info("[orderStatusQuery][loadPay]放款状态加载，结果：放款失败,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//                return queryResult;
//            case DEPOSITORY_FAIL:
//                queryResult.setKaNoticeType(KANoticeType.CANCEL_AFTER_LOAN);
//                return queryResult;
//            case DEPOSITORY_HANDING:
//                // 视为放款成功
//                queryResult.setKaNoticeType(KANoticeType.FUND_SUCC);
//                return queryResult;
//            case HANDING:
//                queryResult.setKaNoticeType(KANoticeType.PAY_ING);
//                return queryResult;
//            default:
//                log.info("[orderStatusQuery][loadPay]放款状态加载，结果：放款中，加载前置状态（提现状态）,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//                return loadDrawOnlyStatus(queryResult, orderMapping);
//        }
//    }
//
//    /**
//     *
//     * @param queryResult
//     * @param orderMapping
//     * @return
//     */
//    private OrderStatusQueryResultOnlyStatus loadDrawOnlyStatus(OrderStatusQueryResultOnlyStatus queryResult, LoanOrderMapping orderMapping) {
//        final Long loanId = orderMapping.getLoanId();
//        if (loanId != null) {
//            queryResult.setKaNoticeType(KANoticeType.WITHDRAW);
//            return queryResult;
//        } else {
//            return loadApproveOnlyStatus(queryResult, orderMapping);
//        }
//    }
//
//    /**
//     *
//     * @param queryResult
//     * @param orderMapping
//     * @return
//     */
//    private OrderStatusQueryResultOnlyStatus loadApproveOnlyStatus(OrderStatusQueryResultOnlyStatus queryResult, LoanOrderMapping orderMapping) {
//        JsonResult jsonResultApprove = exService.queryApproveStatus(orderMapping.getApplyNo());
//        queryResult.setApplyNo(orderMapping.getApplyNo());
//        // 格式："2018-04-21 13:54:02"
//        final String updateAt = String.valueOf(jsonResultApprove.getData());
//        queryResult.setUpdateTime(DateUtil.dateStr2Date(updateAt, DateUtil.DATE_FORMAT_1));
//
//        if (jsonResultApprove.isSuccess()) {
//            queryResult.setKaNoticeType(KANoticeType.FUAD_ASSIFN_SUCC);
//            log.info("[orderStatusQuery][OnlyStatus][loadApprove]审批状态查询加载，结果：审批状态成功,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//        } else if (Constants.APPROVE_FUND_ING_B_CODE.getKey().equals(jsonResultApprove.getBusinessCode())) {
//            // 待审批
//            queryResult.setKaNoticeType(KANoticeType.CREDIT_SUCC);
//            log.info("[orderStatusQuery][OnlyStatus][loadApprove]审批状态查询加载，结果：审批状态审批中,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//        } else if (Constants.APPROVE_FUND_FAIL_B_CODE.getKey().equals(jsonResultApprove.getBusinessCode())) {
//            // 未通过
//            queryResult.setKaNoticeType(KANoticeType.REJECT);
//            log.info("[orderStatusQuery][OnlyStatus][loadApprove]审批状态查询加载，结果：审批未通过,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//        } else if (Constants.LOAN_CANCEL_B_CODE.getKey().equals(jsonResultApprove.getBusinessCode())) {
//            // 借款取消
//            queryResult.setKaNoticeType(KANoticeType.CANCEL_LOAN);
//            log.info("[orderStatusQuery][OnlyStatus][loadApprove]审批状态查询加载，结果：借款取消,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//        } else {
//            queryResult.setKaNoticeType(KANoticeType.CREDIT_SUCC);
//            log.info("[orderStatusQuery][OnlyStatus][loadApprove]审批状态查询加载，结果：未知,applyNo={}, loanId={}", orderMapping.getApplyNo(), orderMapping.getLoanId());
//        }
//        return queryResult;
//    }
//
//    // =======================================only status end ====================================
//
//
//    /**
//     * 审批状态查询
//     * @param applyNo
//     * @return
//     */
//    public JsonResult queryApproveStatus(String applyNo) {
//        Optional<QueryCheckResultResponse> queryApproveStatusOptional = xyqbService.queryCheckResultStatus(applyNo);
//
//        if (!queryApproveStatusOptional.isPresent()) {
//            return JsonResult.buildErrorStateResult("请求失败", "", Constants.APPROVE_FUND_ING_B_CODE.getValue());
//        }
//        if (QueryCheckResultResponse.ProductTypeEnum.CASH.equals(queryApproveStatusOptional.get().getProductType())) {
//            if (queryApproveStatusOptional.get().getStatus() != null) {
//                switch (queryApproveStatusOptional.get().getStatus()) {
//                    case WAITING_RISKCONTROL:
//                    case ASSIGN_INIT:
//                    case ASSIGN_QUEUE:
//                    case ON_ASSIGNING:
//                    case ASSIGN_HANG:
//                    case UN_KNOWN:
//                        // RISKCONTROL_PASS : 风控审批通过，还没分配资金方，不能查询额度
//                    case RISKCONTROL_PASS:
//                        return JsonResult.buildErrorStateResult("审批中", queryApproveStatusOptional.get().getUpdatedAt(), Constants.APPROVE_FUND_ING_B_CODE.getValue());
//                    case FUND_REFUSE://add 风控通过,资金分配失败
//                    case RISKCONTROL_REFUSE:
//                        return JsonResult.buildErrorStateResult("审批未通过", queryApproveStatusOptional.get().getUpdatedAt(), Constants.APPROVE_FUND_FAIL_B_CODE.getValue());
//                    case ASSIGN_FAIL:
//                    case USER_CANCEL:
//                        return JsonResult.buildErrorStateResult("订单取消", queryApproveStatusOptional.get().getUpdatedAt(), Constants.LOAN_CANCEL_B_CODE.getValue());
//                    case ASSIGN_SUCC:
//                        return JsonResult.buildSuccessResult("审批通过", queryApproveStatusOptional.get().getUpdatedAt());
//                    default:return JsonResult.buildErrorStateResult("审批未通过", queryApproveStatusOptional.get().getUpdatedAt(), Constants.APPROVE_FUND_FAIL_B_CODE.getValue());
//                }
//            }
//        } else if (QueryCheckResultResponse.ProductTypeEnum.UN_KNOWN.equals(queryApproveStatusOptional.get().getProductType())) {
//            return JsonResult.buildErrorStateResult("审批中", queryApproveStatusOptional.get().getUpdatedAt(), Constants.APPROVE_FUND_ING_B_CODE.getValue());
//        }
//        return JsonResult.buildErrorStateResult("审批中", queryApproveStatusOptional.get().getUpdatedAt(), Constants.APPROVE_FUND_ING_B_CODE.getValue());
//    }



}
