package cn.quantgroup.cashloanflowboss.spi.clf.model;

import com.google.common.collect.Sets;

import java.util.Set;

/**
 * Created by Miraculous on 15/7/12.
 */
public enum LoanProgress {

    /**
     * 不会被持久化到数据库
     */
    USERINFO_INCOMPLETE("用户未填写个人信息"),//0
    USER_INFORMATION_INCOMPLETE("用户未填写贷款信息"),//1

    USER_AUTHENTICATION_INCOMPLETE("用户授权信息未全部完成"),//2
    USER_AUTHENTICATION_COMPLETE("授权状态完成"),//3
    FURTHER_INFORMATION_INCOMPLETE("用户补充资料未完成"),//4
    PRE_SCREENING("初审中"),//5
    PRE_SCREENING_REJECT("初审拒绝"),//6
    FINAL_SCREENING("终审中"),//7
    FINAL_SCREENING_REJECT("终审拒绝"),//8
    LOAN_APPLICATION_MANIFEST_COMPLETE("借款清单生成完成"),//9
    BIND_BANKCARD("确认借款并且去绑卡"),//10
    BIND_BANKCARD_SUCCESS("绑卡成功"),//11
    QUIT_AND_SHOW_REASON("放弃借款"),//12
    SIGN_CONTRACT("签订协议"),//13
    FUND_TRANSFER("打款"),//14
    CHECK_REPAYMENT_PLAN("查看还款计划"),//15
    LOAN_COMPLETE("借款完成"),//16
    FILTERED_BY_BLACKLIST("黑名单过滤"),//17
    FINAL_SCREENING_PASSED("后台终审通过"),//18
    FILTERING_DECLINED("未通过初筛"),//19
    WAITING_FUND("等待资金方放款"),// 20
    FINAL_SEND_TO_MASHANG_BEFORE_APPROVAL("已发送给马上金融, 等待放款"),//21, 发邮件后更新使用
    FINAL_MASHANG_APPROVAL_SUCCESS("马上金融放款成功"),//22
    FINAL_FUNDED_APPROVAL_FAIL("马上金融放款失败"),//23,
    ADDRESS_COMPLETE("地址填写完毕，去绑卡"), // 24

    BEIYIN_USERINFO_INCOMPLETE("北银消费-用户未填写个人信息"),//25
    BEIYIN_USER_FILE_INCOMPLETE("北银消费-用户未上传文件"),//26
    BEIYIN_SCREENING("北银消费-审批中"),//27
    BEIYIN_SCREENING_FAILED("北银消费-审批失败"),//28
    BEIYIN_SCREENING_PASSED("北银消费-审批通过"),//29
    BEIYIN_LOAN_COMPLETE("北银消费-借款完成"),//30

    BAITIAO_AUTHENTICATION_TAOBAO("白条-淘宝授权"),//31
    BAITIAO_AUTHENTICATION_MOBILE("白条-手机运营商授权"),//32
    BAITIAO_SCREENING("白条-审核中"),//33
    BAITIAO_FILTER_PASSED("白条-初筛通过"),//34
    BAITIAO_SCREENING_FAILED("白条-审核拒绝"),//35
    BAITIAO_SCREENING_PASSED("白条-审核通过"),//36
    BAITIAO_BIND_CARD("白条-绑卡"),//37
    BAITIAO_BIND_CARD_ING("白条-绑卡中"),//38
    BAITIAO_ACTIVATE_SUCC("白条-激活成功"),//39

    /**
     * 修改时间 20160104 资金方解耦
     */
    // category 4x
    /* 易联校验/代收订单 异步通知重构 */
    BIND_BANKCARD_IN_PROGRESS("绑卡处理中"),//40
    /*REPAY_ORDER_IN_PROGRESS("还款处理中")*/
    USER_RELATION_INCOMPLETE("与用户相关联系人信息未完成"),//41,
    PLACE_HOLDER_42("占位"),PLACE_HOLDER_43("占位"),PLACE_HOLDER_44("占位"),
    PLACE_HOLDER_45("占位"),PLACE_HOLDER_46("占位"),PING_AN_PAGE("跳转平安填写信息页面"),// 47
    DROP_SUCC("取消借款"),//48
    PLACE_HOLDER_49("占位"),

    // category 5x
    PLACE_HOLDER_50("占位"),PLACE_HOLDER_51("占位"),PLACE_HOLDER_52("占位"),PLACE_HOLDER_53("占位"),PLACE_HOLDER_54("占位"),
    PLACE_HOLDER_55("占位"),PLACE_HOLDER_56("占位"),PLACE_HOLDER_57("占位"),PLACE_HOLDER_58("占位"),PLACE_HOLDER_59("占位"),

    // category 6x
    PLACE_HOLDER_60("占位"),PLACE_HOLDER_61("占位"),PLACE_HOLDER_62("占位"),PLACE_HOLDER_63("占位"),PLACE_HOLDER_64("占位"),
    WAITING_WITHDRAW("待存管提现"),// 65
    PLACE_HOLDER_66("占位"),PLACE_HOLDER_67("占位"),PLACE_HOLDER_68("占位"),PLACE_HOLDER_69("占位"),

    // category 7x
    PLACE_HOLDER_70("占位"),PLACE_HOLDER_71("占位"),PLACE_HOLDER_72("占位"),PLACE_HOLDER_73("占位"),PLACE_HOLDER_74("占位"),
    PLACE_HOLDER_75("占位"),PLACE_HOLDER_76("占位"),PLACE_HOLDER_77("占位"),PLACE_HOLDER_78("占位"),PLACE_HOLDER_79("占位"),

    // category 8x
    PLACE_HOLDER_80("占位"),PLACE_HOLDER_81("占位"),PLACE_HOLDER_82("占位"),PLACE_HOLDER_83("占位"),PLACE_HOLDER_84("占位"),
    PLACE_HOLDER_85("占位"),PLACE_HOLDER_86("占位"),PLACE_HOLDER_87("占位"),PLACE_HOLDER_88("占位"),PLACE_HOLDER_89("占位"),

    // category 9x
    PLACE_HOLDER_90("占位"),PLACE_HOLDER_91("占位"),PLACE_HOLDER_92("占位"),PLACE_HOLDER_93("占位"),PLACE_HOLDER_94("占位"),
    PLACE_HOLDER_95("占位"),PLACE_HOLDER_96("占位"),PLACE_HOLDER_97("占位"),PLACE_HOLDER_98("占位"),PLACE_HOLDER_99("占位"),

    /**
     * 资金方相关
     */
    // 等待资金方放款 : 100
    WAITING_MASHANG_FUND("等待马上金融放款"),// 100, 发邮件前查询使用
    // 已提交给资金方等待放款 : 101
    SENDED_TO_FUND_CORP("已提交给资金方"),
    // category 10x
    PLACE_HOLDER_102("占位"),PLACE_HOLDER_103("占位"),PLACE_HOLDER_104("占位"),PLACE_HOLDER_105("占位"),PLACE_HOLDER_106("占位"),
    PLACE_HOLDER_107("占位"),PLACE_HOLDER_108("占位"),PLACE_HOLDER_109("占位"),

    JD_BANDCARD_FAIL("京东绑卡失败")//110 京东绑卡失败状态
    ;


    private String description;

    LoanProgress(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return description;
    }

    /**
     * 获取审核拒绝状态
     * @return
     */
    public static Set<LoanProgress> getCheckReject(){
        return Sets.newHashSet(LoanProgress.FILTERING_DECLINED, LoanProgress.PRE_SCREENING_REJECT,
                LoanProgress.FINAL_SCREENING_REJECT, LoanProgress.FILTERED_BY_BLACKLIST);
    }

    /**
     * 获取推送订单状态
     * @return
     */
    public static Set<LoanProgress> getFeedBackOrderStatus(){
        return Sets.newHashSet(LoanProgress.WAITING_FUND, LoanProgress.FINAL_SEND_TO_MASHANG_BEFORE_APPROVAL,
                LoanProgress.FINAL_FUNDED_APPROVAL_FAIL, LoanProgress.CHECK_REPAYMENT_PLAN, LoanProgress.LOAN_COMPLETE);
    }
}
