package cn.quantgroup.cashloanflowboss.api.order.service;

import cn.quantgroup.cashloanflowboss.api.order.model.ApproveVo;
import cn.quantgroup.cashloanflowboss.api.order.model.HistoryOrderStatusVoModel;
import cn.quantgroup.cashloanflowboss.api.order.model.LendingFormModel;
import cn.quantgroup.cashloanflowboss.api.order.model.OrderVo;
import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import cn.quantgroup.cashloanflowboss.spi.clf.model.CallbackRecordVoModel;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * function:
 * date: 2019/9/16
 *
 * @author: suntao
 */
public interface OrderService {
    Page<OrderVo> orderList(Long channelId, String channelOrderNo, String applyNo, Long loanId, Integer pageNumber, Integer pageSize);

    Tuple<Boolean, Boolean> approveOpt(ApproveVo approveVo);

    @Transactional
    boolean secondAudit(String channelOrderNumber);

    @Transactional
    boolean lending(LendingFormModel lendingFormModel);

    boolean cancel(OrderVo orderVo);

    HistoryOrderStatusVoModel getOrderHistoryStatus(String channelOrderNumber);

    boolean cancelPreLoan(String channelOrderNumber);

    boolean cancelAfterLoan(String channelOrderNumber);

    List<CallbackRecordVoModel> getOrderCallbackRecordList(String channelOrderNumber);

    Object findRepaymentPlan(String channelOrderNumber, Long loanId);
}
