package cn.quantgroup.cashloanflowboss.spi.xyqb.source;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages = {"cn.quantgroup.cashloanflowboss.spi.xyqb"}, entityManagerFactoryRef = "xyqbEntityManager", transactionManagerRef = "xyqbTransactionManager", includeFilters = @ComponentScan.Filter(XYQBDataSource.class))
public class XYQBDataSourceConfiguration {

    @Primary
    @Bean
    @ConfigurationProperties(prefix = "data.xyqb")
    public DataSource xyqbDataSource() {

        DruidDataSource source = DruidDataSourceBuilder.create().build();
        source.setMaxActive(200);
        source.setMinIdle(10);
        source.setInitialSize(10);
        source.setMaxWait(500000);
        source.setTimeBetweenEvictionRunsMillis(60000);
        source.setMinEvictableIdleTimeMillis(300000);
        source.setValidationQuery("SELECT 'x'");
        source.setTestWhileIdle(true);
        source.setTestOnBorrow(false);
        source.setTestOnReturn(false);
        source.setPoolPreparedStatements(Boolean.FALSE);
        return source;

    }

    @Bean
    public LocalContainerEntityManagerFactoryBean xyqbEntityManager(EntityManagerFactoryBuilder builder, DataSource xyqbDataSource) {

        return builder.dataSource(xyqbDataSource)
                .packages("cn.quantgroup.cashloanflowboss")
                .persistenceUnit("XYQB-DataSource")
                .build();

    }

    @Bean
    public PlatformTransactionManager xyqbTransactionManager(EntityManagerFactory entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory);
    }

}
