package cn.quantgroup.cashloanflowboss.api.user.service;

import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserStatus;
import cn.quantgroup.cashloanflowboss.api.user.entity.User;
import cn.quantgroup.cashloanflowboss.api.user.repository.UserRepository;
import cn.quantgroup.cashloanflowboss.core.asserts.Assert;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.utils.MD5Tools;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * Created by WeiWei on 2019/7/22.
 */
@Slf4j
@Service
public class UserService {

    @Autowired
    private UserRepository userRepository;

    /**
     * 创建用户
     *
     * @param username 用户名
     * @param password 登录密码（明文）
     * @return
     */
    public boolean createUser(String username, String password) {

        User user = new User();
        user.setUsername(username);
        user.setPassword(MD5Tools.md5(password));
        user.setStatus(UserStatus.ENABLED);

        return Objects.nonNull(this.userRepository.save(user));

    }

    /**
     * 获取用户
     *
     * @param username 用户名
     * @return
     */
    public User getUser(String username) {
        return this.userRepository.getUserByUsername(username);
    }

    /**
     * 获取用户列表（分页）
     *
     * @param pageNumber
     * @param pageSize
     * @return
     */
    public Page<User> getUsers(Integer pageNumber, Integer pageSize) {
        return this.userRepository.findAllBy(new PageRequest(pageNumber, pageSize));
    }

    /**
     * 启用用户
     *
     * @param id 用户ID
     * @return
     */
    public boolean enableUser(String id) {

        User user = this.userRepository.findOne(id);

        // 检查用户是否存在
        Assert.isNull(user, ApplicationStatus.INVALID_USER);

        user.setStatus(UserStatus.ENABLED);

        return Objects.nonNull(this.userRepository.save(user));

    }

    /**
     * 禁用用户
     *
     * @param id 用户ID
     * @return
     */
    public boolean disableUser(String id) {

        User user = this.userRepository.findOne(id);

        // 检查用户是否存在
        Assert.isNull(user, ApplicationStatus.INVALID_USER);

        user.setStatus(UserStatus.DISABLED);

        return Objects.nonNull(this.userRepository.save(user));

    }

    /**
     * 更新用户
     *
     * @param user
     * @return
     */
    public User updateUser(User user) {
        return this.userRepository.save(user);
    }

    /**
     * 移除用户
     *
     * @param id 用户ID
     * @return
     */
    public Boolean removeUser(String id) {

        try {
            this.userRepository.delete(id);
            return true;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

        return false;

    }

}
