package cn.quantgroup.cashloanflowboss.core.asserts;

import cn.quantgroup.cashloanflowboss.core.dictionary.Status;
import cn.quantgroup.cashloanflowboss.core.exception.ApplicationException;

import java.util.Collection;
import java.util.Objects;

/**
 * 断言
 * <p>
 * Created by WeiWei on 2017/7/17.
 */
public class Assert {

    /**
     * 参数是否为False
     *
     * @param object
     * @return
     */
    public static boolean isFalse(Object object) {
        return !isTrue(object);
    }

    /**
     * 参数是否为False，如果是抛出指定异常和描述信息
     *
     * @param object
     * @param status
     */
    public static void isFalse(Object object, Status status) {
        if (!isTrue(object)) {
            throw new ApplicationException(status);
        }
    }

    /**
     * 参数是否为False，如果是抛出指定异常和描述信息
     *
     * @param object
     * @param message
     */
    public static void isFalse(Object object, String message) {
        if (!isTrue(object)) {
            throw new ApplicationException(message);
        }
    }

    /**
     * 参数是否为True
     *
     * @param object
     * @return
     */
    public static boolean isTrue(Object object) {

        if (Boolean.class.isInstance(object)) {
            return (boolean) object;
        }

        return false;

    }

    /**
     * 参数是否为True，如果是抛出指定异常和描述信息
     *
     * @param object
     * @param status
     */
    public static void isTrue(Object object, Status status) {
        if (isTrue(object)) {
            throw new ApplicationException(status);
        }
    }

    /**
     * 参数是否为True，如果是抛出指定异常和描述信息
     *
     * @param object
     * @param message
     */
    public static void isTrue(Object object, String message) {
        if (isTrue(object)) {
            throw new ApplicationException(message);
        }
    }

    /**
     * 参数是否为非Null
     *
     * @param object
     * @return
     */
    public static boolean notNull(Object object) {
        return !isNull(object);
    }

    /**
     * 参数是否为非Null，如果是抛出指定异常和描述信息
     *
     * @param object
     * @param status
     */
    public static void notNull(Object object, Status status) {
        if (notNull(object)) {
            throw new ApplicationException(status);
        }
    }

    /**
     * 参数是否为非Null，如果是抛出指定异常和描述信息
     *
     * @param object
     * @param message
     */
    public static void notNull(Object object, String message) {
        if (notNull(object)) {
            throw new ApplicationException(message);
        }
    }

    /**
     * 参数是否为Null
     *
     * @param object
     * @return
     */
    public static boolean isNull(Object object) {
        return Objects.isNull(object);
    }

    /**
     * 参数是否为Null，如果是抛出指定异常和描述信息
     *
     * @param object
     * @param status
     */
    public static void isNull(Object object, Status status) {
        if (isNull(object)) {
            throw new ApplicationException(status);
        }
    }

    /**
     * 参数是否为Null，如果是抛出指定异常和描述信息
     *
     * @param object
     * @param message
     */
    public static void isNull(Object object, String message) {
        if (isNull(object)) {
            throw new ApplicationException(message);
        }
    }

    /**
     * 字符串参数是否为空
     *
     * @param data
     * @return
     */
    public static boolean isEmpty(String data) {
        return (Objects.isNull(data) || data.isEmpty());
    }

    /**
     * 字符串参数是否为空，如果是抛出指定异常和描述信息
     *
     * @param data
     * @param status
     */
    public static void isEmpty(String data, Status status) {
        if (isEmpty(data)) {
            throw new ApplicationException(status);
        }
    }

    /**
     * 字符串参数是否为空，如果是抛出指定异常和描述信息
     *
     * @param data
     * @param message
     */
    public static void isEmpty(String data, String message) {
        if (isEmpty(data)) {
            throw new ApplicationException(message);
        }
    }

    /**
     * 字符串参数是否为空
     *
     * @param data
     * @param isTrim 是否去除前后导空白
     * @return
     */
    public static boolean isEmpty(String data, boolean isTrim) {
        return isTrim ? isEmpty(data.trim()) : isEmpty(data);
    }

    /**
     * 集合参数是否为空
     *
     * @param collection
     * @return
     */
    public static boolean isEmpty(Collection<?> collection) {
        return (isNull(collection) || collection.isEmpty());
    }

    /**
     * 集合参数是否为空，如果是抛出指定异常和描述信息
     *
     * @param collection
     * @param status
     */
    public static void isEmpty(Collection<?> collection, Status status) {
        if (isEmpty(collection)) {
            throw new ApplicationException(status);
        }
    }

    /**
     * 集合参数是否为空，如果是抛出指定异常和描述信息
     *
     * @param collection
     * @param message
     */
    public static void isEmpty(Collection<?> collection, String message) {
        if (isEmpty(collection)) {
            throw new ApplicationException(message);
        }
    }

    /**
     * 字符串参数是否为非空
     *
     * @param data
     * @return
     */
    public static boolean notEmpty(String data) {
        return (Objects.nonNull(data) && !data.isEmpty());
    }

    /**
     * 字符串参数是否为非空
     *
     * @param data
     * @param isTrim 是否去除前后导空白
     * @return
     */
    public static boolean notEmpty(String data, boolean isTrim) {
        return isTrim ? notEmpty(data.trim()) : notEmpty(data);
    }

    /**
     * 字符串参数是否为非空，如果是抛出指定异常和描述信息
     *
     * @param data
     * @param status
     */
    public static void notEmpty(String data, Status status) {
        if (notEmpty(data)) {
            throw new ApplicationException(status);
        }
    }

    /**
     * 字符串参数是否为非空，如果是抛出指定异常和描述信息
     *
     * @param data
     * @param message
     */
    public static void notEmpty(String data, String message) {
        if (notEmpty(data)) {
            throw new ApplicationException(message);
        }
    }

    /**
     * 集合参数是否为非空
     *
     * @param collection
     * @return
     */
    public static boolean notEmpty(Collection<?> collection) {
        return (notNull(collection) && !collection.isEmpty());
    }

    /**
     * 集合参数是否为非空，如果是抛出指定异常和描述信息
     *
     * @param collection
     * @param status
     */
    public static void notEmpty(Collection<?> collection, Status status) {
        if (notEmpty(collection)) {
            throw new ApplicationException(status);
        }
    }

    /**
     * 集合参数是否为非空，如果是抛出指定异常和描述信息
     *
     * @param collection
     * @param message
     */
    public static void notEmpty(Collection<?> collection, String message) {
        if (notEmpty(collection)) {
            throw new ApplicationException(message);
        }
    }

}
