package cn.quantgroup.cashloanflowboss.spi.xyqb.repository;

import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.Contract;
import cn.quantgroup.cashloanflowboss.spi.xyqb.source.XYQBDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

/**
 * Created by WeiWei on 2019/8/13.
 */
@XYQBDataSource
@Repository
public interface ContractRepository extends JpaRepository<Contract, Long> {

    /**
     * 更新合同状态
     *
     * @param userId
     * @param status
     * @return
     */
    @Modifying
    @Query(value = "update contract set generate_status = ?2 where user_id = ?1", nativeQuery = true)
    int updateContractStatus(Long userId, Integer status);

    Contract findByUserId(Long qgUserId);
}
