package cn.quantgroup.cashloanflowboss.core.dictionary;

import cn.quantgroup.cashloanflowboss.core.exception.ApplicationException;
import lombok.Getter;

/**
 * 应用状态码
 * <p>
 * Created by WeiWei on 2017/5/8.
 */
@Getter
public enum ApplicationStatus implements Status<ApplicationStatus> {

    SUCCESS(200000, "Service request processing successful"),

    FAILURE(500000, "Service request processing failure"),

    INTERNAL_SERVICE_ERROR(500001, "内部服务错误"),

    ARGUMENT_VALID_EXCEPTION(500002, "无效的请求参数"),

    AUTHENTICATION_FAILURE(500003, "非法访问"),

    REENTRY_LOCK_EXCEPTION(500004, "请求过于频繁"),

    JSON_DATA_EXCEPTION(500005, "无效的JSON数据"),

    INVALID_AUTHORITY(501001, "无效的授权"),

    INVALID_USER(501002, "无效的用户"),

    DISABLED_USER(501003, "用户已被禁用"),

    USERNAME_OR_PASSWORD_ERROR(501004, "用户名或密码错误");

    private int code;

    private String message;

    private Status status;

    ApplicationStatus(int code, String message) {
        this.code = code;
        this.message = message;
        this.status = this;
    }

    /**
     * 抛出本状态异常
     */
    public ApplicationException throwException() {
        throw new ApplicationException(this);
    }

}
