package cn.quantgroup.cashloanflowboss.spi.clf.service;

import cn.quantgroup.cashloanflowboss.spi.clf.entity.CallbackFailRecord;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.CallbackRecord;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.CallbackFailRecordRepository;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.CallbackRecordRepository;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.ClfOrderMappingRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * function:
 * date: 2019/9/3
 *
 * @author: suntao
 */
@Service
public class CLFCenterService {


    @Autowired
    private CallbackFailRecordRepository callbackFailRecordRepository;
    @Autowired
    private CallbackRecordRepository callbackRecordRepository;
    @Autowired
    private ClfOrderMappingRepository orderMappingRepository;


    public List<CallbackFailRecord> findCallbackFailRecordByApplyNo(String applyNo) {
        return callbackFailRecordRepository.findByApplyNo(applyNo);
    }

    public List<CallbackRecord> findCallbackRecordByApplyNo(String applyNo) {
        return callbackRecordRepository.findByApplyNo(applyNo);
    }

    public ClfOrderMapping findOrderMappingByChannelOrderNo(String channelOrderNumber) {
        return orderMappingRepository.findByChannelOrderNoLastOne(channelOrderNumber);
    }
}
