package cn.quantgroup.cashloanflowboss.api.log.service;

import cn.quantgroup.cashloanflowboss.api.log.model.Principal;
import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserStatus;
import cn.quantgroup.cashloanflowboss.api.user.entity.User;
import cn.quantgroup.cashloanflowboss.api.user.service.UserService;
import cn.quantgroup.cashloanflowboss.core.asserts.Assert;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationDictionary;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import cn.quantgroup.cashloanflowboss.utils.MD5Tools;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Created by WeiWei on 2019/7/22.
 */
@Slf4j
@Service
public class LogService {

    @Autowired
    private UserService userService;

    @Autowired
    private HttpServletRequest request;

    @Autowired
    private HttpServletResponse response;

    /**
     * 登入
     *
     * @param username 用户名
     * @param password 密码（明文）
     * @return
     */
    public boolean login(String username, String password) {

        User user = this.userService.getUser(username);

        // 检查用户是否有效
        Assert.isNull(user, ApplicationStatus.INVALID_USER);

        // 检查用户是否被禁用
        Assert.isTrue(UserStatus.DISABLED.equals(user.getStatus()), ApplicationStatus.DISABLED_USER);

        // 检查密码是否正确
        Assert.isFalse(user.getPassword().equalsIgnoreCase(MD5Tools.md5(password)), ApplicationStatus.USERNAME_OR_PASSWORD_ERROR);

        // 创建Session
        HttpSession session = this.request.getSession(true);

        // 设置用户主要信息
        Principal principal = new Principal();
        principal.setUserId(user.getId());
        principal.setChannelId(user.getChannelId());
        principal.setRank(user.getRank());
        principal.setRoles(user.getRoles());

        session.setAttribute(ApplicationDictionary.PRINCIPAL, JSONTools.serialize(principal));

        Cookie cookie = new Cookie("JSESSIONID", session.getId());
        cookie.setDomain(".vinceruan.info");
        cookie.setPath("/");

        this.response.addCookie(cookie);

        return true;

    }

    /**
     * 登出
     *
     * @return
     */
    public boolean logout() {

        this.request.getSession().removeAttribute(ApplicationDictionary.PRINCIPAL);

        return true;

    }

}
