CREATE DATABASE IF NOT EXISTS cash_loan_flow_boss CHARACTER SET utf8 COLLATE utf8_general_ci;

use cash_loan_flow_boss;

CREATE TABLE IF NOT EXISTS  `channel_conf` (
  `id` bigint(64) NOT NULL AUTO_INCREMENT COMMENT '物理主键',
  `channel_id` bigint(8) DEFAULT NULL COMMENT '量化派对渠道标记；渠道号',
  `channel_code` varchar(32) DEFAULT '' COMMENT '渠道code',
  `channel_name` varchar(32) DEFAULT '' COMMENT '渠道code',
  `env` varchar(64) DEFAULT '' COMMENT '测试环境',
  `fund_id` bigint(32) DEFAULT NULL COMMENT '资方id',
  `p2p_fund_id` bigint(32) DEFAULT NULL COMMENT '存管资方id',
  `biz_type` bigint(32) DEFAULT NULL COMMENT '业务产品类型productId',
  `aes_key` varchar(64) DEFAULT NULL COMMENT 'aesKey',
  `md5_key` varchar(64) DEFAULT NULL COMMENT 'md5Key',
  `auth_code` varchar(64) DEFAULT NULL COMMENT '提交授信code',
  `risk_code` varchar(64) DEFAULT NULL COMMENT '提交爬虫数据code',
  `env_path` varchar(64) DEFAULT NULL COMMENT '环境域名',
  `channel_ip` varchar(64) DEFAULT NULL COMMENT '渠道ip',
  `approve_call_back_url` varchar(256) DEFAULT NULL COMMENT '审批回调地址',
  `order_status_call_back_url` varchar(256) DEFAULT NULL COMMENT '订单状态回调地址',
  `repay_result_call_back_url` varchar(256) DEFAULT NULL COMMENT '还款结果回调地址',
  `repayment_plan_call_back_url` varchar(256) DEFAULT NULL COMMENT '还款计划回调地址',
  `message` text,
  `extend_data` text COMMENT '扩展信息',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_channel_id` (`channel_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='渠道配置表';



# table opt_history_log
# ------------------------------------------------------------


CREATE TABLE IF NOT EXISTS `opt_history_log` (
  `id` int(20) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `channel_order_number` varchar(64) DEFAULT NULL COMMENT '渠道订单号',
  `credit_number` varchar(64) DEFAULT NULL COMMENT '授信订单号',
  `loan_id` bigint(32) DEFAULT NULL COMMENT '提现单号',
  `channel_id` bigint(32) DEFAULT NULL COMMENT '渠道号',
  `opt_name` varchar(64) DEFAULT NULL COMMENT '操作节点(功能)名称',
  `opt_enum_name` varchar(64) DEFAULT NULL COMMENT '操作节点(功能)枚举值',
  `opt_user` varchar(64) DEFAULT NULL COMMENT '操作员',
  `opt_log_detail` text,
  `ext_data` text,
  `opt_result` bigint(2) DEFAULT NULL COMMENT '是否成功 1 成功 0 失败',
  `create_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='操作记录日志';



# table order_approve
# ------------------------------------------------------------


CREATE TABLE IF NOT EXISTS `order_approve` (
  `id` int(20) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `channel_order_number` varchar(64) DEFAULT NULL COMMENT '渠道订单号',
  `credit_number` varchar(64) DEFAULT NULL COMMENT '授信订单号',
  `channel_id` bigint(32) NOT NULL COMMENT '渠道号',
  `fund_id` bigint(16) DEFAULT NULL COMMENT '资方id',
  `fund_type` bigint(2) DEFAULT NULL COMMENT '资方类型0：非存管；1：存管',
  `ext_data` text,
  `create_time` timestamp NOT NULL,
  `update_time` timestamp NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;




# Dump of table permission
# ------------------------------------------------------------

DROP TABLE IF EXISTS `permission`;

CREATE TABLE `permission` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `desc` varchar(256) NOT NULL,
  `authorities` varchar(256) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8;

LOCK TABLES `permission` WRITE;
/*!40000 ALTER TABLE `permission` DISABLE KEYS */;

INSERT INTO `permission` (`id`, `name`, `desc`, `authorities`)
VALUES
	(1,'Log.logout','退出',''),
	(2,'Log.1','登陆操作1',''),
	(3,'Channel.getChannelList','查询渠道列表',''),
	(4,'Channel.getChannelConfInfo','查询单个渠道详细',''),
	(5,'Channel.editChannelConfInfo','编辑单个渠道详细',''),
	(6,'Channel.delete','删除渠道',''),
	(7,'Channel.back1','渠道操作占位1',''),
	(8,'Channel.back2','渠道操作占位2',''),
	(9,'User.addUser','添加用户',''),
	(10,'User.delete','删除用户',''),
	(11,'User.list','查询用户列表',''),
	(12,'User.disable','禁用用户',''),
	(13,'User.enable','启用用户',''),
	(14,'User.Order.cleanUserOrder','清除用户活跃订单',''),
	(15,'User.Order.cleanUserInfo','清除用户在xyqbUser信息',''),
	(16,'User.back1','用户操作占位1',''),
	(17,'User.back2','用户操作占位2',''),
	(18,'User.back2','用户操作占位2',''),
	(19,'Role.roleList','查询角色列表',''),
	(20,'Role.delete','删除角色',''),
	(21,'Role.saveRole','修改保存角色',''),
	(22,'Role.back1','角色占位1',''),
	(23,'Role.back2','角色占位2',''),
	(24,'Role.back3','角色占位3',''),
	(25,'Permission.outOfRolePermission','权限.查询用户未拥有的权限',''),
	(26,'Permission.permissionList','权限.查询所有权限',''),
	(27,'Permission.savePermission','新增修改权限',''),
	(28,'Permission.delete','删除某个权限',''),
	(29,'Permission.1','权限操作占位1',''),
	(30,'Permission.2','权限操作占位2',''),
	(31,'Order.getOrderHistoryStatus','查询历史订单状态',''),
	(32,'Order.orderCallbackRecordList','查询订单推送记录',''),
	(33,'Order.secondAudit','订单二次风控审批',''),
	(34,'Order.loadSecondAuditJob','刷新待放款定时任务',''),
	(35,'Order.getOrderList','查询订单列表',''),
	(36,'Order.approveOpt','订单审批',''),
	(37,'Order.lending','订单放款',''),
	(38,'Order.cancelPreLoan','贷前关单',''),
	(39,'Order.cancelAfterLoan','贷后关单','');

/*!40000 ALTER TABLE `permission` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table role
# ------------------------------------------------------------

DROP TABLE IF EXISTS `role`;

CREATE TABLE `role` (
  `id` int(20) NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `parent_id` int(20) DEFAULT NULL COMMENT '父角色ID',
  `name` varchar(32) NOT NULL COMMENT '角色名称',
  `desc` varchar(128) NOT NULL DEFAULT '' COMMENT '角色描述',
  `max_rank` varchar(128) NOT NULL DEFAULT '' COMMENT '最大rank',
  `create_time` timestamp NOT NULL,
  `update_time` timestamp NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;

INSERT INTO `role` (`id`, `parent_id`, `name`, `desc`, `max_rank`, `create_time`, `update_time`)
VALUES
	(1,NULL,'admin','系统维护管理员','','2019-08-06 13:31:26','2019-08-06 13:31:26'),
	(2,NULL,'量化派操作员','除了添加权限 和 角色 之外都有权限','','2019-08-06 13:31:26','2019-08-06 13:31:26'),
	(3,NULL,'总渠道','拥有查询，和订单操作权限','','2019-08-06 13:31:37','2019-08-06 13:31:37'),
	(4,3,'普通渠道','普通渠道','','2019-08-06 13:31:37','2019-08-06 13:31:37'),
	(5,NULL,'量化派查询角色','查询 权限','','2019-08-06 13:31:26','2019-08-06 13:31:26'),
	(6,5,'量化派产品','产品角色','','2019-08-06 13:31:26','2019-08-06 13:31:26'),
	(7,5,'量化派运营','运营角色','','2019-08-06 13:31:26','2019-08-06 13:31:26'),
	(8,2,'量化派测试','量化派测试','','2019-08-06 13:31:26','2019-08-06 13:31:26'),
	(9,2,'量化派开发','量化派开发','','2019-08-06 13:31:26','2019-08-06 13:31:26');

/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table role_permission_mapping
# ------------------------------------------------------------

DROP TABLE IF EXISTS `role_permission_mapping`;

CREATE TABLE `role_permission_mapping` (
  `role_id` bigint(20) NOT NULL,
  `permission_id` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

LOCK TABLES `role_permission_mapping` WRITE;
/*!40000 ALTER TABLE `role_permission_mapping` DISABLE KEYS */;

INSERT INTO `role_permission_mapping` (`role_id`, `permission_id`)
VALUES
	(2,1),
	(2,2),
	(2,3),
	(2,4),
	(2,5),
	(2,6),
	(2,7),
	(2,8),
	(2,9),
	(2,10),
	(2,11),
	(2,12),
	(2,13),
	(2,14),
	(2,15),
	(2,16),
	(2,17),
	(2,18),
	(2,31),
	(2,32),
	(2,33),
	(2,34),
	(2,35),
	(2,36),
	(2,37),
	(2,38),
	(2,39),
	(3,1),
	(3,2),
	(3,3),
	(3,4),
	(3,5),
	(3,7),
	(3,8),
	(3,14),
	(3,15),
	(3,16),
	(3,17),
	(3,18),
	(3,31),
	(3,32),
	(3,33),
	(3,34),
	(3,35),
	(3,36),
	(3,37),
	(3,38),
	(3,39),
	(5,1),
	(5,2),
	(5,3),
	(5,4),
	(5,7),
	(5,8),
	(5,31),
	(5,32),
	(5,35),
	(9,1),
	(9,2),
	(9,3),
	(9,4),
	(9,5),
	(9,6),
	(9,7),
	(9,8),
	(9,9),
	(9,10),
	(9,11),
	(9,12),
	(9,13),
	(9,14),
	(9,15),
	(9,16),
	(9,17),
	(9,18),
	(9,31),
	(9,32),
	(9,33),
	(9,34),
	(9,35),
	(9,36),
	(9,37),
	(9,38),
	(9,39);

/*!40000 ALTER TABLE `role_permission_mapping` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table user
# ------------------------------------------------------------

DROP TABLE IF EXISTS `user`;

CREATE TABLE `user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(32) NOT NULL,
  `nickname` varchar(64) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL,
  `channel_id` int(11) DEFAULT NULL COMMENT '渠道ID',
  `rank` varchar(64) NOT NULL COMMENT '用户级别',
  `status` varchar(10) DEFAULT NULL,
  `create_time` timestamp NOT NULL,
  `update_time` timestamp NOT NULL,
  `last_login_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;

INSERT INTO `user` (`id`, `username`, `nickname`, `password`, `channel_id`, `rank`, `status`, `create_time`, `update_time`, `last_login_time`)
VALUES
	(1,'admin','帝释天','81DC9BDB52D04DC20036DBD8313ED055',NULL,'SUPER_ADMINISTRATOR','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(2,'admin01','超级boss','81DC9BDB52D04DC20036DBD8313ED055',NULL,'SUPER_ADMINISTRATOR','ENABLED','2019-08-06 13:33:15','2019-08-06 13:33:15','2019-08-06 13:33:15'),
	(3,'yqg01','洋钱罐','202CB962AC59075B964B07152D234B70',159766,'CHANNEL','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(4,'qiancheng','浅橙','202CB962AC59075B964B07152D234B70',159507,'CHANNEL','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(5,'zhangzhong','掌众','202CB962AC59075B964B07152D234B70',159858,'CHANNEL','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(6,'shiguang','时光分期','202CB962AC59075B964B07152D234B70',159865,'CHANNEL','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(7,'pm01','量化派产品0','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(8,'pm02','量化派产品1','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-08-06 12:08:05','2019-08-06 12:08:05',NULL),
	(9,'yunying','运营1','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:03:57','2019-09-19 18:03:57',NULL),
	(10,'yunying2','运营2','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05',NULL),
	(11,'huhui','胡慧','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05',NULL),
	(12,'suntao','suntao','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05',NULL),
	(13,'guomei','guomei','202CB962AC59075B964B07152D234B70',159843,'CHANNEL','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05','2019-08-06 13:33:15'),
	(14,'shangying','尚英','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05','2019-08-06 13:33:15'),
	(15,'jiangsuxia','素霞','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05','2019-08-06 13:33:15'),
	(16,'ameng','阿蒙','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05','2019-08-06 13:33:15'),
	(17,'chenxiaoze','晓哲','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05','2019-08-06 13:33:15'),
	(18,'fengjie','雷总','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05','2019-08-06 13:33:15'),
	(19,'lupeng','鹿朋','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05','2019-08-06 13:33:15'),
	(20,'wangjunquan','俊权','202CB962AC59075B964B07152D234B70',NULL,'OPERATOR','ENABLED','2019-09-19 18:06:05','2019-09-19 18:06:05','2019-08-06 13:33:15');

/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table user_role_mapping
# ------------------------------------------------------------

DROP TABLE IF EXISTS `user_role_mapping`;

CREATE TABLE `user_role_mapping` (
  `user_id` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '',
  `role_id` varchar(255) COLLATE utf8_bin NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

LOCK TABLES `user_role_mapping` WRITE;
/*!40000 ALTER TABLE `user_role_mapping` DISABLE KEYS */;

INSERT INTO `user_role_mapping` (`user_id`, `role_id`)
VALUES
	('1','1'),
	('2','1'),
	('3','4'),
	('4','4'),
	('5','4'),
	('6','4'),
	('7','6'),
	('8','6'),
	('9','6'),
	('10','6'),
	('11','8'),
	('12','9'),
	('13','4'),
	('14','8'),
	('15','8'),
	('16','8'),
	('17','9'),
	('18','9'),
	('19','9'),
	('20','9');

/*!40000 ALTER TABLE `user_role_mapping` ENABLE KEYS */;
UNLOCK TABLES;



/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
