package cn.quantgroup.cashloanflowboss.spi.apollo.service;

import cn.quantgroup.cashloanflowboss.spi.util.HttpService;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * function:
 * date: 2019/10/28
 *
 * @author: suntao
 */
@Slf4j
@Service
public class ApolloSettingServiceImpl implements ApolloSettingService {

    @Autowired
    private HttpService httpService;

    @Value("${eos.ips}")
    private String eosIps;


    @Override
    public Map<String,Object> getParamsFromEOS(String namespace, String... keys){

        Map<String, Object> result = new HashedMap(keys.length);

        if (keys.length == 0) {
            return result;
        }

        for (String eosIp : eosIps.split(",")) {
            String response = null;
            try{
                Map<String, String> httpParam = new HashMap<>(2);
                httpParam.put("namespace", namespace);
                response = httpService.get("http://"+eosIp.trim()+"/api/apollo/env_vars", httpParam);
            }catch (Exception e){
                continue;
            }


            JSONObject json = JSON.parseObject(response);

            if(json == null){
                continue;
            }
            JSONObject details = json.getJSONObject("details");
            if(details == null || details.isEmpty()){
                continue;
            }

            for (String key : keys) {
                result.put(key,details.get(key));
            }

        }
        log.info("[getParamsFromEOS],result={}", JSONObject.toJSONString(result));
        return result;

    }
}
