package cn.quantgroup.cashloanflowboss.core.aspect;

import cn.quantgroup.cashloanflowboss.api.login.model.Principal;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.annotation.channelrole.CheckChannelRole;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.ClfOrderMappingRepository;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * function:
 * date: 2019/8/6
 *
 * @author: suntao
 */
@Slf4j
@Component
@Aspect
@Order(2)
public class ChannelRoleCheckAspect {


    @Pointcut("@annotation(cn.quantgroup.cashloanflowboss.core.annotation.channelrole.CheckChannelRole)")
    private void checkRole() {}


    @Autowired
    private ClfOrderMappingRepository clfOrderMappingRepository;


    /**
     * 通过 channelId 或者 channelOrderNumber  判断 如果是渠道用户登陆  是否当前渠道
     * @param pjp
     */
    @Around(value = "checkRole()")
    public Object checkRoleBefore(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        MethodSignature methodSignature = (MethodSignature) pjp.getSignature();
        Method method = methodSignature.getMethod();

        Principal principal = Application.getPrincipal();
        if (principal == null) {
            try {
                return pjp.proceed(args);
            } catch (Throwable throwable) {
                log.error("请求失败，e={}", ExceptionUtils.getStackTrace(throwable));
                return Result.buildFial();
            }
        }

        // 如果是渠道用户登陆，参数中channelId 不是登陆用户channelId，返回 拒绝请求
        CheckChannelRole checkChannelRoleAnno = method.getAnnotation(CheckChannelRole.class);

        if (checkChannelRoleAnno != null) {
            String channelIdSPEL = checkChannelRoleAnno.channelIdSPEL();
            String channelOrderNumberSPEL = checkChannelRoleAnno.channelOrderNumberSPEL();

            if (StringUtils.isAllEmpty(channelIdSPEL, channelOrderNumberSPEL)) {
                log.error("[CheckChannelRole]channelIdSPEL, channelOrderNumberSPEL 不能都为空");
                return Result.buildFial(ApplicationStatus.ARGUMENT_VALID_EXCEPTION);
            }

            if (principal.isChannel()) {
                if (StringUtils.isNotEmpty(channelIdSPEL)) {
                    // 通过channelId 判断
                    try {
                        if (channelIdSPEL.startsWith("#this")) {
                            Expression expression = new SpelExpressionParser().parseExpression(channelIdSPEL);

                            if (!Application.getPrincipal().getChannelId().equals(expression.getValue(args, Long.class))) {
                                log.info("[CheckChannelRole]渠道用户，登陆channelId与查询channelId不是同一个");
                                return Result.buildFial(ApplicationStatus.INVALID_AUTHORITY);
                            }
                        } else {
                            log.warn("[CheckChannelRole]channelIdSPEL取值失败");
                        }
                    } catch (ExpressionException e) {
                        log.error("[CheckChannelRole]key表达式“" + channelIdSPEL + "”错误：{}", e);
                        throw e;
                    }
                } else if (StringUtils.isNotEmpty(channelOrderNumberSPEL)){
                    // 通过channelOrderNumber 判断
                    String channelOrderNumber = "";
                    if (channelOrderNumberSPEL.startsWith("#this")) {
                        Expression expression = new SpelExpressionParser().parseExpression(channelOrderNumberSPEL);
                        channelOrderNumber = expression.getValue(args, String.class);
                    } else {
                        log.warn("[CheckChannelRole]channelOrderNumberSPEL取值失败");
                    }
                    if (StringUtils.isNotEmpty(channelOrderNumber)) {

                        ClfOrderMapping clfOrderMapping = clfOrderMappingRepository.findByChannelOrderNoLastOne(channelOrderNumber);
                        if (clfOrderMapping == null) {
                            log.info("[CheckChannelRoleByChannelOrderNumber]无channelOrderNumber数据，channelOrderNumber={}",channelOrderNumber);
                            return Result.buildFial(ApplicationStatus.ARGUMENT_VALID_EXCEPTION, "未找到该订单");
                        }
                        if (!clfOrderMapping.getRegisteredFrom().equals(principal.getChannelId())) {
                            log.info("[CheckChannelRoleByChannelOrderNumber]不是该渠道的订单，channelOrderNumber={}",channelOrderNumber);
                            return Result.buildFial(ApplicationStatus.INVALID_AUTHORITY);
                        }
                    }
                }

            }
        }


        try {
            return pjp.proceed(args);
        } catch (Throwable throwable) {
            log.error("请求失败，e={}", ExceptionUtils.getStackTrace(throwable));
            return Result.buildFial();
        }
    }


}
