package cn.quantgroup.cashloanflowboss.spi.xyqb.service;

import cn.quantgroup.cashloanflowboss.api.order.model.XyqbCurrentOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.api.order.model.XyqbHistoryOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.spi.xyqb.client.XYQBCenter;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.ContractRepository;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.FundLendingRepository;
import cn.quantgroup.cashloanflowboss.spi.xyqb.util.SignUtil;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by WeiWei on 2019/8/12.
 */
@Service
public class XYQBCenterService {

    @Autowired
    private FundLendingRepository fundLendingRepository;

    @Autowired
    private ContractRepository contractRepository;

    @Autowired
    private XYQBCenter xyqbCenter;

    /**
     * 更新资方待放款创建时间
     *
     * @return
     */
    public boolean updateFundLendingTime(Long loanId) {
        return this.fundLendingRepository.updateCreateTime(loanId, new Date());
    }

    /**
     * 更新合同状态
     *
     * @param userId
     * @return
     */
    public boolean updateContractStatus(Long userId, Integer status) {
        return this.contractRepository.updateContractStatus(userId, status);
    }

    /**
     * 查询放款记录
     *
     * @param fundId
     * @param progress
     * @return
     */
    public Map queryLendingRecordCount(Integer fundId, Integer progress) {
        return this.fundLendingRepository.queryLendingRecordCount(fundId, progress);
    }

    /**
     * 生成放款结果MQ
     *
     * @param loanId
     * @param status
     * @return
     */
    public boolean pushLendingResult(Long loanId, Integer status) {

        // TODO WEIWEI 查看返回的数据结构，补充判断逻辑

        String data = this.xyqbCenter.pushLendingResult(new HashMap() {{
            put("orderNo", loanId);
            put("payOrderNo", loanId);
            put("payTime", new Date().getTime());
            put("payStatus", status);
        }});

        return false;

    }


    /**
     * 查询订单当前状态
     * @param creditOrderNumber
     * @param loanId
     * @return
     */
    public Result<XyqbCurrentOrderStatusServiceResultModel> getXyqbOrderStatus(String creditOrderNumber, Long loanId) {

        Map paramMap = Maps.newHashMap();
        paramMap.put("orderNo", creditOrderNumber);
        if (loanId != null) {
            paramMap.put("loanId", loanId);
        }
        paramMap = SignUtil.sign(SignUtil.KA_API_KEY, paramMap);

        return xyqbCenter.getOrderStatus(paramMap);
    }

    /**
     * 查询订单当前状态
     * @param creditOrderNumber
     * @param loanId
     * @return
     */
    public Result<XyqbHistoryOrderStatusServiceResultModel> getXyqbOrderHistoryStatus(String creditOrderNumber, Long loanId) {

        Map paramMap = Maps.newHashMap();
        paramMap.put("orderNo", creditOrderNumber);
        if (loanId != null) {
            paramMap.put("loanId", loanId);
        }
        paramMap = SignUtil.sign(SignUtil.KA_API_KEY, paramMap);

        return xyqbCenter.getXyqbOrderHistoryStatus(paramMap);
    }

}
