package cn.quantgroup.cashloanflowboss.spi.clotho.client;

import cn.quantgroup.cashloanflowboss.spi.clotho.exception.ClothoCenterException;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * function:
 * date: 2019/8/9
 *
 * @author: suntao
 */

@Component
@FeignClient(name = "ClothoServiceCenter", url = "${fund.pay.api-host}", fallback = ClothoCenter.Fallback.class)
public interface ClothoCenter {

    @PostMapping(value = "/external/quota/auth_amount_audit/notify", consumes = "application/x-www-form-urlencoded")
    String approve(@RequestParam Map approveData);

    /**
     * 生成放款MQ消息
     *
     * @param data
     * @return
     */
    @PostMapping(value = "/ex/paycenter/pay_notify", consumes = "application/x-www-form-urlencoded")
    String generatorLendingMessage(@RequestParam Map data);

    /**
     * 放款
     *
     * @param data
     * @return
     */
    @PostMapping(value = "clotho/funds/plan/loan/apply", consumes = "application/x-www-form-urlencoded")
    String lending(@RequestParam Map data);

    @Component
    class Fallback implements ClothoCenter {

        @Override
        public String approve(Map approveData) {
            return "error1";
        }

        @Override
        public String generatorLendingMessage(Map data) {
            throw new ClothoCenterException();
        }

        @Override
        public String lending(Map data) {
            return null;
        }

    }
}
