package cn.quantgroup.cashloanflowboss.api.optlog.repository;

import cn.quantgroup.cashloanflowboss.api.optlog.entity.OptHistoryLog;
import cn.quantgroup.cashloanflowboss.api.order.entity.OrderApprove;
import cn.quantgroup.cashloanflowboss.core.persistence.CashLoanFlowBossDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * function:
 * date: 2019/8/12
 *
 * @author: suntao
 */
@CashLoanFlowBossDataSource
@Repository
public interface OptHistoryLogRepository extends PagingAndSortingRepository<OptHistoryLog, Long>, JpaSpecificationExecutor<OptHistoryLog> {


    @Query(value = "select * from opt_history_log where channel_order_number=?1 and opt_enum_name = ?2 limit 1", nativeQuery = true)
    OptHistoryLog findByChannelOrderNumberAndOptName(String channelOrderNumber, int opName);

    @Query(value = "select * from opt_history_log where channel_order_number=?1 and opt_enum_name = ?2 and opt_result=1 limit 1", nativeQuery = true)
    OptHistoryLog findByChannelOrderNumberAndOptNameAndSuccess(String channelOrderNumber, int opName);

    List<OptHistoryLog> findByChannelOrderNumber(String channelOrderNumber);

    List<OptHistoryLog> findByCreditNumber(String creditOrderNumber);

}
