package cn.quantgroup.cashloanflowboss.api.login.model;

import cn.quantgroup.cashloanflowboss.api.role.entity.Role;
import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserRank;
import lombok.Data;

import java.util.Objects;
import java.util.Set;

/**
 * Created by WeiWei on 2019/7/26.
 */
@Data
public class Principal {

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户级别
     */
    private UserRank rank;

    /**
     * 所属渠道ID
     */
    private Long channelId;

    /**
     * 角色列表
     */
    private Set<Role> roles;

    /**
     * 是否是超级管理员
     *
     * @return
     */
    public boolean isSuperAdministrator() {
        return Objects.nonNull(this.rank) && UserRank.SUPER_ADMINISTRATOR.equals(this.rank);
    }

    /**
     * 是否管理员
     *
     * @return
     */
    public boolean isAdministrator() {
        return Objects.nonNull(this.rank) && UserRank.ADMINISTRATOR.equals(this.rank);
    }

    /**
     * 是否操作员
     *
     * @return
     */
    public boolean isOperator() {
        return Objects.nonNull(this.rank) && UserRank.OPERATOR.equals(this.rank);
    }

    /**
     * 是否渠道的
     *
     * @return
     */
    public boolean isChannel() {
        return Objects.nonNull(this.rank) && UserRank.CHANNEL.equals(this.rank);
    }

    /**
     * 判断当前用户和渠道参数是否相同
     *
     * @param channelId
     * @return
     */
    public boolean isSameChannel(Long channelId) {
        return Objects.nonNull(channelId) && channelId.equals(this.channelId);
    }

}
