package cn.quantgroup.cashloanflowboss.core.configuration;

import cn.quantgroup.cashloanflowboss.api.log.model.Principal;
import cn.quantgroup.cashloanflowboss.api.role.entity.Role;
import cn.quantgroup.cashloanflowboss.component.security.Authority;
import cn.quantgroup.cashloanflowboss.component.security.SecurityHandler;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.asserts.Assert;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.annotation.Configuration;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * Created by WeiWei on 2019/7/26.
 */
@Configuration
public class ApplicationSecurityHandler implements SecurityHandler {

    @Override
    public boolean doAuthentication(MethodInvocation invocation, String authorityId, Authority[] authority) throws Throwable {

        Principal principal = Application.getPrincipal();

        // 检查是否已登录
        Assert.isNull(principal, ApplicationStatus.AUTHENTICATION_FAILURE);

        // 如果是超级管理员跳过权限验证
        return principal.isSuperAdministrator() || principal.getRoles().stream().anyMatch(role -> Stream.iterate(role, Role::getParent).anyMatch(_role -> this.checkAuthority(authorityId, _role)));

    }

    /**
     * 检查权限
     *
     * @param authorityId
     * @param role
     * @return
     */
    private boolean checkAuthority(String authorityId, Role role) {
        return Objects.nonNull(role.getPermissions()) && role.getPermissions().parallelStream().anyMatch(permission -> permission.getId().equals(authorityId));
    }

}
