package cn.quantgroup.cashloanflowboss.core.configuration;

import cn.quantgroup.cashloanflowboss.component.security.Power;
import cn.quantgroup.cashloanflowboss.component.security.SecurityHandler;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationDictionary;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import com.fasterxml.jackson.core.type.TypeReference;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

/**
 * Created by WeiWei on 2019/7/26.
 */
@Configuration
public class ApplicationSecurityConfiguration implements SecurityHandler {

    @Autowired
    private HttpServletRequest request;

    @Override
    public boolean doAuthentication(MethodInvocation invocation, String authorityId, Power[] power) throws Throwable {

        HttpSession session = this.request.getSession();
        Map<String, Power> permissions = JSONTools.deserialize(String.valueOf(session.getAttribute(ApplicationDictionary.SECURITY_KEY)), new TypeReference<Map<String, Power>>() {});

        return Objects.nonNull(permissions) && permissions.containsKey(authorityId) && Arrays.asList(power).contains(permissions.get(authorityId));

    }

}
