package cn.quantgroup.cashloanflowboss.core.configuration.data;

import cn.quantgroup.cashloanflowboss.core.persistence.CashLoanFlowDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages = {"cn.quantgroup"}, entityManagerFactoryRef = "xyqbUserEntityManager", transactionManagerRef = "xyqbUserTransactionManager", includeFilters = @ComponentScan.Filter(CashLoanFlowDataSource.class))
public class XyqbUserDataSourceConfiguration {

  @Value("${data.xyqb.user.url}")
  private String jdbcUrl;

  @Value("${data.xyqb.user.password}")
  private String password;

  @Value("${data.xyqb.user.username}")
  private String user;

  private String uniquename = "clfDS";

  @Value("${data.xyqb.user.pool-size}")
  private Integer poolSize;

  @Bean(name = "clfDataSource")
  @ConfigurationProperties(prefix = "data.clf")
  public DataSource createDataSource() {
    DruidDataSource source = DruidDataSourceBuilder.create().build();
    source.setMaxActive(200);
    source.setInitialSize(10);
    source.setMinIdle(10);
    source.setMaxWait(500000);
    source.setTimeBetweenEvictionRunsMillis(60000);
    source.setMinEvictableIdleTimeMillis(300000);
    source.setValidationQuery("SELECT 'x'");
    source.setTestWhileIdle(true);
    source.setTestOnBorrow(false);
    source.setTestOnReturn(false);
    source.setPoolPreparedStatements(Boolean.FALSE);
    return source;
  }

  @Bean(name = "xyqbUserEntityManager")
  public LocalContainerEntityManagerFactoryBean entityManager(EntityManagerFactoryBuilder builder) {

    return builder.dataSource(createDataSource())
        .packages("cn.quantgroup.cashloanflowboss.spi.clf.entity")
        .persistenceUnit(uniquename)
        .build();
  }

  @Bean(name = "xyqbUserTransactionManager")
  public PlatformTransactionManager transactionManager(@Qualifier("xyqbUserEntityManager") EntityManagerFactory entityManagerFactory) {
    return new JpaTransactionManager(entityManagerFactory);
  }

}
