package cn.quantgroup.cashloanflowboss.spi.xyqb.source;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.sql.DataSource;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages = {"cn.quantgroup"}, includeFilters = @ComponentScan.Filter(XYQBDataSource.class))
public class XYQBDataSourceConfiguration {

    @Bean
    public DataSource xyqbDataSource(@Autowired XYQBDataSourceProperty dataSourceProperty) {

        DruidDataSource source = DruidDataSourceBuilder.create().build();

        source.setMaxActive(dataSourceProperty.getMaxActive());
        source.setMinIdle(dataSourceProperty.getMinIdle());
        source.setInitialSize(dataSourceProperty.getInitialSize());
        source.setMaxWait(500000);
        source.setTimeBetweenEvictionRunsMillis(60000);
        source.setMinEvictableIdleTimeMillis(300000);
        source.setValidationQuery("SELECT 'x'");
        source.setTestWhileIdle(true);
        source.setTestOnBorrow(false);
        source.setTestOnReturn(false);
        source.setPoolPreparedStatements(Boolean.FALSE);

        return source;

    }

}
