package cn.quantgroup.cashloanflowboss.spi.xyqb.source;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Created by WeiWei on 2019/8/12.
 */
@Data
@ConfigurationProperties("application.datasource.xyqb")
public class XYQBDataSourceProperty {

    /**
     * JDBC连接URL
     */
    private String jdbcURL;

    /**
     * 数据库用户名
     */
    private String username;

    /**
     * 数据库密码
     */
    private String password;

    /**
     * 最大连接数
     */
    private Integer maxActive = 30;

    /**
     * 最小连接数
     */
    private Integer minIdle = 1;

    /**
     * 初始连接数
     */
    private Integer initialSize = 5;

}
