package cn.quantgroup.cashloanflowboss.api.channel.controller;

import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfAddModel;
import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfBaseModel;
import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfVo;
import cn.quantgroup.cashloanflowboss.core.annotation.ChannelIdInit;
import cn.quantgroup.cashloanflowboss.api.channel.service.ChannelConfService;
import cn.quantgroup.cashloanflowboss.core.annotation.CheckChannelRole;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.Map;

/**
 * Created with suntao on 2019/8/2
 * @author suntao
 */
@RestController
@RequestMapping("channel")
public class ChannelConfController {


    @Autowired
    private ChannelConfService channelConfService;


    /**
     * 查询渠道列表
     * @param channelId 在接受参数时，必须放到第一个参数位置
     * @param pageNumber
     * @param pageSize
     * @return
     */
    @ChannelIdInit
    @PostMapping("/info")
    public Result channelInfo(Long channelId, Integer pageNumber, Integer pageSize) {
        return Result.buildSuccess(channelConfService.getChannelInfo(pageNumber, pageSize, channelId));
    }


    @CheckChannelRole
    @GetMapping("/cfg/info")
    public Result getChannelConfInfo(Long channelId) {
        return Result.buildSuccess(channelConfService.getChannelConf(channelId), "success");
    }


    @CheckChannelRole(isObjParam = true ,paramClazz = ChannelConfVo.class)
    @PostMapping("/cfg/info")
    public Result editChannelConfInfo(@RequestBody @Valid ChannelConfVo channelConfVo) {
        return Result.buildSuccess(channelConfService.editChannelConfInfo(channelConfVo));
    }



}
