package cn.quantgroup.cashloanflowboss.core.base;

import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.core.dictionary.Status;
import lombok.Data;

import java.util.Objects;

/**
 * 请求返回数据结构实体类
 * <p>
 * Created by WeiWei on 2017/5/2.
 */
@Data
public class ServiceResult<T> {

    /**
     * 状态码
     */
    private Integer code;

    /**
     * 描述信息
     */
    private String message;

    /**
     * 返回结果
     */
    private T data;

    public ServiceResult() {}

    public ServiceResult(Status status) {
        this(status, null);
    }

    public ServiceResult(Status status, T data) {
        this(status, data, null);
    }

    public ServiceResult(Status status, T data, String message) {

        if (Objects.nonNull(status)) {
            this.code = status.getCode();
            this.message = Objects.isNull(message) ? status.getMessage() : message;
            this.data = data;
        }

    }


    @SuppressWarnings("unchecked")
    public static <T> ServiceResult<T> buildSuccess(T data) {
        return new ServiceResult(ApplicationStatus.SUCCESS, data);
    }

    @SuppressWarnings("unchecked")
    public static <T> ServiceResult<T> buildSuccess(T data, String message) {
        return new ServiceResult(ApplicationStatus.SUCCESS, data, message);
    }

    @SuppressWarnings("unchecked")
    public static <T> ServiceResult<T> buildFial(T data) {
        return new ServiceResult(ApplicationStatus.FAILURE, data);
    }

    @SuppressWarnings("unchecked")
    public static <T> ServiceResult<T> buildFial(String message) {
        return new ServiceResult(ApplicationStatus.FAILURE, null, message);
    }

    @SuppressWarnings("unchecked")
    public static <T> ServiceResult<T> buildFial() {
        return new ServiceResult(ApplicationStatus.FAILURE, null, null);
    }

    @SuppressWarnings("unchecked")
    public static <T> ServiceResult<T> buildFial(ApplicationStatus applicationStatus) {
        return new ServiceResult(applicationStatus, null, null);
    }

    @SuppressWarnings("unchecked")
    public static <T> ServiceResult<T> buildFial(T data, String message) {
        return new ServiceResult(ApplicationStatus.FAILURE, data, message);
    }


    public Boolean isSuccess(){
        return Objects.nonNull(this.code) && this.code == 0;
    }

}
