package cn.quantgroup.cashloanflowboss.api.order.service;

import cn.quantgroup.cashloanflowboss.api.order.model.OrderVo;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.ClfOrderMappingRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * function:
 * date: 2019/8/8
 *
 * @author: suntao
 */

@Service
public class OrderService {

    @Autowired
    private ClfOrderMappingRepository clfOrderMappingRepository;


    public Page<OrderVo> getOrders(Long channelId, String channelOrderNo, Integer pageNumber, Integer pageSize) {
        Page<ClfOrderMapping> page = this.clfOrderMappingRepository.findAll((root, criteriaQuery, criteriaBuilder) -> {

            List<Predicate> predicates = new ArrayList<>();

            // 指定渠道号
            if (Objects.nonNull(channelId)) {
                predicates.add(criteriaBuilder.equal(root.get("registeredFrom"), channelId.longValue()));
            }
            if (StringUtils.isNotEmpty(channelOrderNo)) {
                predicates.add(criteriaBuilder.equal(root.get("channelOrderNo"), channelOrderNo));
            }

            // 设置查询条件
            criteriaQuery.where(criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()])));
            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));

            return criteriaQuery.getRestriction();

        }, new PageRequest(pageNumber, pageSize));

        return page.map(it-> {
            OrderVo orderVo = new OrderVo();
            orderVo.setId(it.getId());
            orderVo.setChannelId(it.getRegisteredFrom());
            orderVo.setChannelOrderNumber(it.getChannelOrderNo());
            orderVo.setCreatedAt(it.getCreatedAt().getTime());



            orderVo.setStatus("");
            orderVo.setOpt("");
            orderVo.setMessage("");
            return orderVo;
        });
    }

}
