package cn.quantgroup.cashloanflowboss.core.aspect;

import cn.quantgroup.cashloanflowboss.api.user.model.UserSessionInfo;
import cn.quantgroup.cashloanflowboss.api.user.service.UserSessionService;
import cn.quantgroup.cashloanflowboss.core.annotation.RoleDataLoad;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * function:
 * date: 2019/8/6
 *
 * @author: suntao
 */
@Slf4j
@Component
@Aspect
@Order(Ordered.HIGHEST_PRECEDENCE)
public class RoleDataLoadAspect {

    @Autowired
    private UserSessionService userSessionService;

    @Pointcut("execution(* cn.quantgroup.cashloanflowboss.api.channel.controller.*.*(..))")
    private void channelRoleInit() {}

    @Around(value = "channelRoleInit()")
    public Object around(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        MethodSignature methodSignature = (MethodSignature) pjp.getSignature();
        Method method = methodSignature.getMethod();
        RoleDataLoad annotation = method.getAnnotation(RoleDataLoad.class);
        UserSessionInfo userSessionInfo = userSessionService.findUserSessionInfo();

        if (annotation != null && "channel_role".equals(userSessionInfo.getRoleInfo().getRoleName())) {
            System.out.println(userSessionInfo.getChannelId());
        }

        try {
            return pjp.proceed(args);
        } catch (Throwable throwable) {
            return Result.buildFial(ExceptionUtils.getMessage(throwable));
        }
    }


}
