package cn.quantgroup.cashloanflowboss.spi.clotho.service;

import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.spi.clotho.client.ClothoCenter;
import cn.quantgroup.cashloanflowboss.spi.clotho.model.LendingServiceModel;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by WeiWei on 2019/8/12.
 */
@Slf4j
@Service
public class ClothoCenterService {

    @Autowired
    private ClothoCenter clothoCenter;

    @Value("${debug.model}")
    public Boolean debugModel;



    public Boolean orderAuditNotify(String uuid, Long loanId, boolean auditResult, int bizType) {
        Map notify = new HashMap();
        notify.put("code", 0);
        notify.put("msg", "success");
        notify.put("bizChannel", 1);
        notify.put("uuid", uuid);
        notify.put("bizNo", loanId);
        notify.put("bizType", bizType);
        notify.put("auditResult", auditResult);
        return "success".equals(clothoCenter.orderAuditNotify(notify));
    }


    /**
     * 生成放款MQ消息
     *
     * @return
     */
    public String generatorLendingMessage(LendingServiceModel lendingServiceModel) {
        return this.clothoCenter.generatorLendingMessage(JSONTools.toMap(lendingServiceModel));
    }

    /**
     * 放款
     *
     * @return
     */
    public boolean lending(Integer fundId, BigDecimal amountLimit, Integer pepoleLimit) {

        if (debugModel) {
            String data = this.clothoCenter.lending(new HashMap(4) {{
                put("fundingCorpId", fundId);
                put("amountLimit", amountLimit);
                put("peopleLimit", pepoleLimit);
            }});

            return "success".equals(data);
        } else {
            return false;
        }

    }


    /**
     * 审批
     * @param approveData
     * @return
     */
    public String approve(Map<String, Object> approveData) {
        if (debugModel) {
            return clothoCenter.approve(approveData);
        } else {
            return "error";
        }
    }

    public String cancelPreLoan(Map<Object, Object> data) {
        if (debugModel) {
            return clothoCenter.cancelPreLoan(data);
        } else {
            return "error";
        }
    }

    public String cancelAfterLoan(Map<Object, Object> data) {
        if (debugModel) {
            return clothoCenter.cancelAfterLoan(data);
        } else {
            return "error";
        }
    }

}
