package cn.quantgroup.cashloanflowboss.component.security;

import cn.quantgroup.cashloanflowboss.component.security.annotiation.Security;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.context.support.ApplicationObjectSupport;

import java.io.Serializable;

/**
 * Created by WeiWei on 2018/2/1.
 */
public class SecurityInterceptor extends ApplicationObjectSupport implements MethodInterceptor, Serializable {

    @Override
    public Object invoke(final MethodInvocation invocation) throws Throwable {

        Security security = invocation.getMethod().getAnnotation(Security.class);
        Tuple<Boolean, ApplicationStatus> doAuthentication = this.getApplicationContext().getBean(SecurityHandler.class).doAuthentication(invocation, security.authorityId(), security.authorities());
        if (BooleanUtils.isFalse(doAuthentication.getKey())) {
            // 未通过验证
            return Result.buildFail(doAuthentication.getValue());
        }

        return invocation.proceed();

    }

}
